/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.AbstractDelegatingStore;
import org.infinispan.loaders.decorators.AsyncStoreConfig;
import org.infinispan.loaders.modifications.Clear;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.loaders.modifications.ModificationsList;
import org.infinispan.loaders.modifications.Remove;
import org.infinispan.loaders.modifications.Store;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.locks.containers.ReentrantPerEntryLockContainer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AsyncStore
extends AbstractDelegatingStore {
    private static final Log log = LogFactory.getLog(AsyncStore.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final AtomicInteger threadId = new AtomicInteger(0);
    private final AtomicBoolean stopped = new AtomicBoolean(true);
    private final AsyncStoreConfig asyncStoreConfig;
    private Map<GlobalTransaction, List<? extends Modification>> transactions;
    private static final Modification QUIT_SIGNAL = new Clear();
    private final ReadWriteLock clearAllLock = new ReentrantReadWriteLock();
    private final Lock clearAllReadLock = this.clearAllLock.readLock();
    private final Lock clearAllWriteLock = this.clearAllLock.writeLock();
    private final Lock stateMapLock = new ReentrantLock();
    ExecutorService executor;
    private int concurrencyLevel;
    @GuardedBy(value="stateMapLock")
    protected ConcurrentMap<Object, Modification> state;
    private ReleaseAllLockContainer lockContainer;
    private final LinkedBlockingQueue<Modification> changesDeque = new LinkedBlockingQueue();
    public volatile boolean lastAsyncProcessorShutsDownExecutor = false;

    public AsyncStore(CacheStore delegate, AsyncStoreConfig asyncStoreConfig) {
        super(delegate);
        this.asyncStoreConfig = asyncStoreConfig;
    }

    @Override
    public void init(CacheLoaderConfig config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(config, cache, m);
        this.concurrencyLevel = cache == null || cache.getConfiguration() == null ? 16 : cache.getConfiguration().getConcurrencyLevel();
        this.lockContainer = new ReleaseAllLockContainer(this.concurrencyLevel);
        this.transactions = new ConcurrentHashMap<GlobalTransaction, List<? extends Modification>>(64, 0.75f, this.concurrencyLevel);
    }

    @Override
    public void store(InternalCacheEntry ed) {
        this.enqueue(new Store(ed));
    }

    @Override
    public boolean remove(Object key) {
        this.enqueue(new Remove(key));
        return true;
    }

    @Override
    public void clear() {
        Clear clear = new Clear();
        this.checkNotStopped();
        this.changesDeque.clear();
        this.enqueue(clear);
    }

    @Override
    public void prepare(List<? extends Modification> mods, GlobalTransaction tx, boolean isOnePhase) throws CacheLoaderException {
        if (isOnePhase) {
            this.enqueueModificationsList(mods);
        } else {
            this.transactions.put(tx, mods);
        }
    }

    @Override
    public void rollback(GlobalTransaction tx) {
        this.transactions.remove(tx);
    }

    @Override
    public void commit(GlobalTransaction tx) throws CacheLoaderException {
        List<? extends Modification> list = this.transactions.remove(tx);
        this.enqueueModificationsList(list);
    }

    protected void enqueueModificationsList(List<? extends Modification> mods) throws CacheLoaderException {
        if (mods != null && !mods.isEmpty()) {
            this.enqueue(new ModificationsList(mods));
        }
    }

    @Override
    public void start() throws CacheLoaderException {
        this.state = this.newStateMap();
        log.info((Object)"Async cache loader starting %s", this);
        this.stopped.set(false);
        this.lastAsyncProcessorShutsDownExecutor = false;
        super.start();
        int poolSize = this.asyncStoreConfig.getThreadPoolSize();
        this.executor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(poolSize + 1), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "CoalescedAsyncStore-" + threadId.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        }, new ThreadPoolExecutor.DiscardPolicy());
        this.startStoreCoordinator();
    }

    private void startStoreCoordinator() {
        ExecutorService storeCoordinator = Executors.newFixedThreadPool(1);
        storeCoordinator.execute(new AsyncStoreCoordinator());
        storeCoordinator.shutdown();
    }

    @Override
    public void stop() throws CacheLoaderException {
        this.stopped.set(true);
        try {
            this.changesDeque.put(QUIT_SIGNAL);
            this.executor.awaitTermination(this.asyncStoreConfig.getShutdownTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error((Object)"Interrupted or timeout while waiting for AsyncStore worker threads to push all state to the decorated store", e);
            Thread.currentThread().interrupt();
        }
        super.stop();
    }

    protected void applyModificationsSync(ConcurrentMap<Object, Modification> mods) throws CacheLoaderException {
        Set entries = mods.entrySet();
        block4: for (Map.Entry entry : entries) {
            Modification mod = (Modification)entry.getValue();
            switch (mod.getType()) {
                case STORE: {
                    super.store(((Store)mod).getStoredEntry());
                    continue block4;
                }
                case REMOVE: {
                    super.remove(entry.getKey());
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unexpected modification type " + (Object)((Object)mod.getType()));
        }
    }

    protected boolean applyClear() {
        try {
            super.clear();
            return true;
        }
        catch (CacheLoaderException e) {
            log.error((Object)"Error performing clear in AsyncStore", e);
            return false;
        }
    }

    protected void delegatePurgeExpired() {
        try {
            super.purgeExpired();
        }
        catch (CacheLoaderException e) {
            log.error((Object)"Error performing PurgeExpired in AsyncStore", e);
        }
    }

    private void enqueue(Modification mod) {
        try {
            this.checkNotStopped();
            if (trace) {
                log.trace((Object)"Enqueuing modification %s", mod);
            }
            this.changesDeque.add(mod);
        }
        catch (Exception e) {
            throw new CacheException("Unable to enqueue asynchronous task", e);
        }
    }

    private void checkNotStopped() {
        if (this.stopped.get()) {
            throw new CacheException("AsyncStore stopped; no longer accepting more entries.");
        }
    }

    private void acquireLock(Lock lock) {
        try {
            if (!lock.tryLock(this.asyncStoreConfig.getFlushLockTimeout(), TimeUnit.MILLISECONDS)) {
                throw new CacheException("Unable to acquire lock on update map");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    private ConcurrentMap<Object, Modification> newStateMap() {
        return new ConcurrentHashMap<Object, Modification>(64, 0.75f, this.concurrencyLevel);
    }

    private void ensureMoreWorkIsHandled() {
        this.executor.execute(new AsyncProcessor());
    }

    private class AsyncStoreCoordinator
    implements Runnable {
        private AsyncStoreCoordinator() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Modification take;
                        if ((take = (Modification)AsyncStore.this.changesDeque.take()) == QUIT_SIGNAL) {
                            AsyncStore.this.lastAsyncProcessorShutsDownExecutor = true;
                            AsyncStore.this.ensureMoreWorkIsHandled();
                            return;
                        }
                        this.handleSafely(take);
                    }
                }
                catch (InterruptedException e) {
                    log.error((Object)"AsyncStoreCoordinator interrupted", e);
                    return;
                }
                catch (Throwable t) {
                    log.error((Object)"Unexpected error in AsyncStoreCoordinator thread. AsyncStore is dead!", t);
                    continue;
                }
                break;
            }
        }

        private void handleSafely(Modification mod) {
            try {
                if (trace) {
                    log.trace((Object)"taking from modification queue: %s", mod);
                }
                this.handle(mod, false);
            }
            catch (Exception e) {
                log.error((Object)"Error while handling Modification in AsyncStore", e);
            }
        }

        private void handle(Modification mod, boolean nested) {
            boolean asyncProcessorNeeded = false;
            switch (mod.getType()) {
                case STORE: {
                    Store store = (Store)mod;
                    AsyncStore.this.stateMapLock.lock();
                    AsyncStore.this.state.put(store.getStoredEntry().getKey(), store);
                    AsyncStore.this.stateMapLock.unlock();
                    asyncProcessorNeeded = true;
                    break;
                }
                case REMOVE: {
                    Remove remove = (Remove)mod;
                    AsyncStore.this.stateMapLock.lock();
                    AsyncStore.this.state.put(remove.getKey(), remove);
                    AsyncStore.this.stateMapLock.unlock();
                    asyncProcessorNeeded = true;
                    break;
                }
                case CLEAR: {
                    this.performClear();
                    break;
                }
                case PURGE_EXPIRED: {
                    AsyncStore.this.delegatePurgeExpired();
                    break;
                }
                case LIST: {
                    this.applyModificationsList((ModificationsList)mod);
                    asyncProcessorNeeded = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected modification type " + (Object)((Object)mod.getType()));
                }
            }
            if (asyncProcessorNeeded && !nested) {
                AsyncStore.this.ensureMoreWorkIsHandled();
            }
        }

        private void applyModificationsList(ModificationsList mod) {
            for (Modification modification : mod.getList()) {
                this.handle(modification, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performClear() {
            AsyncStore.this.state.clear();
            AsyncStore.this.clearAllWriteLock.lock();
            try {
                AsyncStore.this.state.clear();
                if (trace) {
                    log.trace("Performed clear operation");
                }
                int maxRetries = 3;
                int attemptNumber = 0;
                boolean successful = false;
                do {
                    if (attemptNumber <= 0 || !log.isDebugEnabled()) continue;
                    log.debug((Object)"Retrying clear() due to previous failure. %s attempts left.", maxRetries - attemptNumber);
                } while (!(successful = AsyncStore.this.applyClear()) && ++attemptNumber <= maxRetries);
                if (!successful) {
                    log.error("Clear() operation in async store could not be performed");
                }
            }
            finally {
                AsyncStore.this.clearAllWriteLock.unlock();
            }
        }
    }

    private static class ReleaseAllLockContainer
    extends ReentrantPerEntryLockContainer {
        private ReleaseAllLockContainer(int concurrencyLevel) {
            super(concurrencyLevel);
        }

        void releaseLocks(Set<Object> keys) {
            for (Object key : keys) {
                if (trace) {
                    log.trace((Object)"Release lock for key %s", key);
                }
                this.releaseLock(key);
            }
        }
    }

    class AsyncProcessor
    implements Runnable {
        private final Set<Object> lockedKeys = new HashSet<Object>();
        boolean runAgainAfterWaiting = false;

        AsyncProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AsyncStore.this.clearAllReadLock.lock();
            try {
                this.innerRun();
            }
            catch (Throwable t) {
                this.runAgainAfterWaiting = false;
                log.error((Object)"Unexpected error", t);
            }
            finally {
                AsyncStore.this.clearAllReadLock.unlock();
            }
            if (this.runAgainAfterWaiting) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                AsyncStore.this.ensureMoreWorkIsHandled();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void innerRun() {
            if (trace) {
                log.trace("Checking for modifications");
            }
            try {
                boolean successful;
                ConcurrentMap<Object, Modification> swap;
                AsyncStore.this.acquireLock(AsyncStore.this.stateMapLock);
                try {
                    swap = AsyncStore.this.state;
                    AsyncStore.this.state = AsyncStore.this.newStateMap();
                    for (Object key : swap.keySet()) {
                        if (trace) {
                            log.trace((Object)"Going to process mod key: %s", key);
                        }
                        boolean acquired = false;
                        try {
                            acquired = AsyncStore.this.lockContainer.acquireLock(key, 0L, TimeUnit.NANOSECONDS) != null;
                        }
                        catch (InterruptedException e) {
                            log.error((Object)"interrupted on acquireLock %s, 0 nanoseconds!", e);
                            Thread.currentThread().interrupt();
                            AsyncStore.this.stateMapLock.unlock();
                            AsyncStore.this.lockContainer.releaseLocks(this.lockedKeys);
                            this.lockedKeys.clear();
                            return;
                        }
                        if (trace) {
                            log.trace((Object)"Lock for key %s was acquired=%s", key, acquired);
                        }
                        if (!acquired) {
                            Modification prev = (Modification)swap.remove(key);
                            Modification didPut = AsyncStore.this.state.putIfAbsent(key, prev);
                            if (didPut != null) continue;
                            this.runAgainAfterWaiting = true;
                            continue;
                        }
                        this.lockedKeys.add(key);
                    }
                }
                finally {
                    AsyncStore.this.stateMapLock.unlock();
                }
                if (swap.isEmpty()) {
                    if (AsyncStore.this.lastAsyncProcessorShutsDownExecutor && !this.runAgainAfterWaiting) {
                        AsyncStore.this.executor.shutdown();
                    }
                    return;
                }
                if (trace) {
                    log.trace((Object)"Apply %s modifications", swap.size());
                }
                int maxRetries = 3;
                int attemptNumber = 0;
                do {
                    if (attemptNumber <= 0 || !log.isDebugEnabled()) continue;
                    log.debug((Object)"Retrying due to previous failure. %s attempts left.", maxRetries - attemptNumber);
                } while (!(successful = this.put(swap)) && ++attemptNumber <= maxRetries);
                if (!successful) {
                    log.warn("Unable to process some async modifications after " + maxRetries + " retries!");
                }
            }
            finally {
                AsyncStore.this.lockContainer.releaseLocks(this.lockedKeys);
                this.lockedKeys.clear();
            }
        }

        boolean put(ConcurrentMap<Object, Modification> mods) {
            try {
                AsyncStore.this.applyModificationsSync(mods);
                return true;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Failed to process async modifications", e);
                }
                return false;
            }
        }
    }
}

