/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.ReversibleOrderedSet;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.LockManager;

public class LockingInterceptor
extends CommandInterceptor {
    LockManager lockManager;
    DataContainer dataContainer;
    EntryFactory entryFactory;
    boolean useReadCommitted;
    Transport transport;

    @Inject
    public void setDependencies(LockManager lockManager, DataContainer dataContainer, EntryFactory entryFactory, Transport transport) {
        this.lockManager = lockManager;
        this.dataContainer = dataContainer;
        this.entryFactory = entryFactory;
        this.transport = transport;
    }

    @Start
    private void determineIsolationLevel() {
        this.useReadCommitted = this.configuration.getIsolationLevel() == IsolationLevel.READ_COMMITTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                throw new IllegalStateException("Attempting to do a commit or rollback but there is no transactional context in scope. " + ctx);
            }
            this.cleanupLocks(ctx, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isInTxScope()) {
                throw new IllegalStateException("Attempting to do a commit or rollback but there is no transactional context in scope. " + ctx);
            }
            this.cleanupLocks(ctx, false);
        }
    }

    private void abortIfRemoteTransactionInvalid(TxInvocationContext ctx, AbstractTransactionBoundaryCommand c) {
        if (!ctx.isOriginLocal()) {
            Address origin = c.getGlobalTransaction().getAddress();
            if (!this.transport.getMembers().contains(origin)) {
                throw new CacheException("Member " + origin + " no longer in cluster. Forcing tx rollback for " + c.getGlobalTransaction());
            }
        }
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        try {
            this.abortIfRemoteTransactionInvalid(ctx, command);
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (TimeoutException te) {
            this.cleanupLocks(ctx, false);
            throw te;
        }
        finally {
            if (command.isOnePhaseCommit()) {
                this.cleanupLocks(ctx, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForReading(ctx, command.getKey());
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand c) throws Throwable {
        Boolean bl;
        boolean localTxScope = ctx.isOriginLocal() && ctx.isInTxScope();
        boolean shouldInvokeOnCluster = false;
        try {
            boolean goRemoteFirst;
            this.abortIfRemoteTransactionInvalid(ctx, c);
            if (localTxScope) {
                c.attachGlobalTransaction((GlobalTransaction)ctx.getLockOwner());
            }
            if (c.isUnlock()) {
                this.lockManager.releaseLocks(ctx);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Lock released for: " + ctx.getLockOwner());
                }
                Boolean bl2 = false;
                return bl2;
            }
            for (Object key : c.getKeys()) {
                if (!c.isImplicit() || !localTxScope || this.lockManager.ownsLock(key, ctx.getLockOwner())) continue;
                shouldInvokeOnCluster = true;
                break;
            }
            boolean bl3 = goRemoteFirst = this.configuration.isEnableDeadlockDetection() && localTxScope;
            if (goRemoteFirst) {
                Object result = this.invokeNextInterceptor(ctx, c);
                try {
                    this.lockKeysForLockCommand(ctx, c);
                    result = true;
                }
                catch (Throwable e) {
                    result = false;
                    c.setUnlock(true);
                    this.invokeNextInterceptor(ctx, c);
                    throw e;
                }
                Object object = result;
                return object;
            }
            this.lockKeysForLockCommand(ctx, c);
            if (shouldInvokeOnCluster || c.isExplicit()) {
                this.invokeNextInterceptor(ctx, c);
                bl = true;
                return bl;
            }
            bl = true;
            return bl;
        }
        catch (Throwable te) {
            this.cleanLocksAndRethrow(ctx, te);
            bl = false;
            return bl;
        }
        finally {
            if (!ctx.isInTxScope()) {
                throw new IllegalStateException("Attempting to lock but there is no transactional context in scope. " + ctx);
            }
            this.doAfterCall(ctx);
        }
    }

    private void lockKeysForLockCommand(TxInvocationContext ctx, LockControlCommand c) throws InterruptedException {
        for (Object key : c.getKeys()) {
            MVCCEntry e = this.entryFactory.wrapEntryForWriting((InvocationContext)ctx, key, true, false, false, false, false);
            if (e == null || !e.isCreated()) continue;
            e.setLockPlaceholder(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        try {
            for (InternalCacheEntry entry : this.dataContainer.entrySet()) {
                this.entryFactory.wrapEntryForWriting(ctx, entry, false, false, false, false, false);
            }
            Object i$ = this.invokeNextInterceptor(ctx, command);
            return i$;
        }
        catch (Throwable te) {
            Object object = this.cleanLocksAndRethrow(ctx, te);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        ctx.setFlags(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
        return this.visitRemoveCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        try {
            if (command.getKeys() != null) {
                for (Object key : command.getKeys()) {
                    this.entryFactory.wrapEntryForWriting(ctx, key, false, true, false, false, false);
                }
            }
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable throwable) {
            Object object = this.cleanLocksAndRethrow(ctx, throwable);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitInvalidateL1Command(InvocationContext ctx, InvalidateL1Command command) throws Throwable {
        Object[] keys = command.getKeys();
        try {
            ArrayList<Object> keysCopy;
            if (keys != null && keys.length >= 1) {
                keysCopy = new ArrayList<Object>(Arrays.asList(keys));
                for (Object key : command.getKeys()) {
                    ctx.setFlags(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
                    try {
                        this.entryFactory.wrapEntryForWriting(ctx, key, false, true, false, false, false);
                    }
                    catch (TimeoutException te) {
                        this.log.warn((Object)"Could not lock key %s in order to invalidate from L1 at node %s, skipping....", key, this.transport.getAddress());
                        keysCopy.remove(key);
                        if (!keysCopy.isEmpty()) continue;
                        Object var10_11 = null;
                        command.setKeys(keys);
                        this.doAfterCall(ctx);
                        return var10_11;
                    }
                }
                command.setKeys(keysCopy.toArray());
            }
            keysCopy = this.invokeNextInterceptor(ctx, command);
            return keysCopy;
        }
        catch (Throwable te) {
            Object object = this.cleanLocksAndRethrow(ctx, te);
            return object;
        }
        finally {
            command.setKeys(keys);
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), true, false, false, false, !command.isPutIfAbsent());
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable te) {
            Object object = this.cleanLocksAndRethrow(ctx, te);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        try {
            for (Object key : command.getMap().keySet()) {
                this.entryFactory.wrapEntryForWriting(ctx, key, true, false, false, false, true);
            }
            Object i$ = this.invokeNextInterceptor(ctx, command);
            return i$;
        }
        catch (Throwable te) {
            Object object = this.cleanLocksAndRethrow(ctx, te);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), false, true, false, true, false);
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable te) {
            Object object = this.cleanLocksAndRethrow(ctx, te);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            this.entryFactory.wrapEntryForWriting(ctx, command.getKey(), false, true, false, false, false);
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable te) {
            Object object = this.cleanLocksAndRethrow(ctx, te);
            return object;
        }
        finally {
            this.doAfterCall(ctx);
        }
    }

    private void doAfterCall(InvocationContext ctx) {
        if (!ctx.isInTxScope()) {
            this.cleanupLocks(ctx, true);
        } else {
            BidirectionalMap<Object, CacheEntry> lookedUpEntries;
            if (this.trace) {
                this.log.trace("Transactional.  Not cleaning up locks till the transaction ends.");
            }
            if (this.useReadCommitted && (lookedUpEntries = ctx.getLookedUpEntries()) != null && !lookedUpEntries.isEmpty()) {
                ArrayList keysToRemove = new ArrayList(lookedUpEntries.size());
                for (Map.Entry e : lookedUpEntries.entrySet()) {
                    if (this.lockManager.possiblyLocked((CacheEntry)e.getValue()) || this.possiblyLockedInContext(ctx, e.getKey())) continue;
                    keysToRemove.add(e.getKey());
                }
                if (!keysToRemove.isEmpty()) {
                    if (this.trace) {
                        this.log.trace((Object)"Removing keys %s since they have not been modified.  Context currently contains %s keys", keysToRemove, ctx.getLookedUpEntries().size());
                    }
                    for (Map.Entry key : keysToRemove) {
                        ctx.removeLookedUpEntry(key);
                    }
                    if (this.trace) {
                        this.log.trace((Object)"After removal, context contains %s keys", ctx.getLookedUpEntries().size());
                    }
                }
            }
        }
    }

    private boolean possiblyLockedInContext(InvocationContext ctx, Object key) {
        if (ctx instanceof LocalTxInvocationContext) {
            return ((LocalTxInvocationContext)ctx).getAffectedKeys().contains(key);
        }
        return false;
    }

    private void cleanupLocks(InvocationContext ctx, boolean commit) {
        if (commit) {
            Object owner = ctx.getLockOwner();
            ReversibleOrderedSet<Map.Entry<Object, CacheEntry>> entries = ctx.getLookedUpEntries().entrySet();
            Iterator<Map.Entry<Object, CacheEntry>> it = entries.reverseIterator();
            if (this.trace) {
                this.log.trace((Object)"Number of entries in context: %s", entries.size());
            }
            while (it.hasNext()) {
                Map.Entry<Object, CacheEntry> e = it.next();
                CacheEntry entry = e.getValue();
                Object key = e.getKey();
                boolean needToUnlock = this.lockManager.possiblyLocked(entry);
                if (entry != null && entry.isChanged()) {
                    this.commitEntry(entry);
                } else if (this.trace) {
                    this.log.trace((Object)"Entry for key %s is null, not calling commitUpdate", key);
                }
                if (!needToUnlock || ctx.hasFlag(Flag.SKIP_LOCKING)) continue;
                if (this.trace) {
                    this.log.trace("Releasing lock on [" + key + "] for owner " + owner);
                }
                this.lockManager.unlock(key);
            }
        } else {
            this.lockManager.releaseLocks(ctx);
        }
    }

    private Object cleanLocksAndRethrow(InvocationContext ctx, Throwable te) throws Throwable {
        this.cleanupLocks(ctx, false);
        throw te;
    }

    protected void commitEntry(CacheEntry entry) {
        entry.commit(this.dataContainer);
    }
}

