/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.CacheException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.transaction.xa.TransactionTable;

public class InvocationContextInterceptor
extends CommandInterceptor {
    private TransactionManager tm;
    private ComponentRegistry componentRegistry;
    private TransactionTable txTable;

    @Inject
    public void init(TransactionManager tm, ComponentRegistry componentRegistry, TransactionTable txTable) {
        this.tm = tm;
        this.componentRegistry = componentRegistry;
        this.txTable = txTable;
    }

    @Override
    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.handleAll(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand lcc) throws Throwable {
        Object retval = this.handleAll(ctx, lcc);
        return retval == null ? Boolean.valueOf(false) : retval;
    }

    private Object handleAll(InvocationContext ctx, VisitableCommand command) throws Throwable {
        boolean suppressExceptions = false;
        ComponentStatus status = this.componentRegistry.getStatus();
        if (status.isTerminated()) {
            throw new IllegalStateException(String.format("%s is in 'TERMINATED' state and so it does not accept new invocations. Either restart it or recreate the cache container.", this.getCacheNamePrefix()));
        }
        if (this.stoppingAndNotAllowed(status, ctx)) {
            throw new IllegalStateException(String.format("%s is in 'STOPPING' state and this is an invocation not belonging to an on-going transaction, so it does not accept new invocations. Either restart it or recreate the cache container.", this.getCacheNamePrefix()));
        }
        if (this.trace) {
            this.log.trace((Object)"Invoked with command %s and InvocationContext [%s]", command, ctx);
        }
        if (ctx == null) {
            throw new IllegalStateException("Null context not allowed!!");
        }
        if (ctx.hasFlag(Flag.FAIL_SILENTLY)) {
            suppressExceptions = true;
        }
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable th) {
            if (suppressExceptions) {
                this.log.trace((Object)"Exception while executing code, failing silently...", th);
                Object var6_7 = null;
                return var6_7;
            }
            this.log.error((Object)"Execution error: ", th);
            if (ctx.isInTxScope() && ctx.isOriginLocal()) {
                if (this.trace) {
                    this.log.trace("Transaction marked for rollback as exception was received.");
                }
                this.markTxForRollbackAndRethrow(ctx, th);
                throw new IllegalStateException("This should not be reached");
            }
            throw th;
        }
        finally {
            ctx.reset();
        }
    }

    private String getCacheNamePrefix() {
        String cacheName = this.componentRegistry.getCacheName();
        String prefix = "Cache '" + cacheName + "'";
        if (cacheName.equals("___defaultcache")) {
            prefix = "Default cache";
        }
        return prefix;
    }

    private boolean stoppingAndNotAllowed(ComponentStatus status, InvocationContext ctx) throws Exception {
        return status.isStopping() && (!ctx.isInTxScope() || ctx.isInTxScope() && this.txTable.getLocalTransaction(this.tm.getTransaction()) == null);
    }

    private Object markTxForRollbackAndRethrow(InvocationContext ctx, Throwable te) throws Throwable {
        Transaction transaction;
        if (ctx.isOriginLocal() && ctx.isInTxScope() && (transaction = this.tm.getTransaction()) != null && this.isValidRunningTx(transaction)) {
            transaction.setRollbackOnly();
        }
        throw te;
    }

    public boolean isValidRunningTx(Transaction tx) throws Exception {
        int status;
        try {
            status = tx.getStatus();
        }
        catch (SystemException e) {
            throw new CacheException("Unexpected!", e);
        }
        return status == 0 || status == 7;
    }
}

