/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.CacheException;
import org.infinispan.distribution.ch.AbstractConsistentHash;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.marshall.Marshallable;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Immutables;

@Marshallable(externalizer=Externalizer.class, id=52)
public class UnionConsistentHash
extends AbstractConsistentHash {
    ConsistentHash oldCH;
    ConsistentHash newCH;

    public UnionConsistentHash(ConsistentHash oldCH, ConsistentHash newCH) {
        if (oldCH instanceof UnionConsistentHash || newCH instanceof UnionConsistentHash) {
            throw new CacheException("Expecting both newCH and oldCH to not be Unions!!  oldCH=[" + oldCH.getClass() + "] and newCH=[" + newCH.getClass() + "]");
        }
        this.oldCH = oldCH;
        this.newCH = newCH;
    }

    @Override
    public void setCaches(Set<Address> caches) {
    }

    @Override
    public Set<Address> getCaches() {
        return Collections.emptySet();
    }

    @Override
    public List<Address> locate(Object key, int replCount) {
        LinkedHashSet<Address> addresses = new LinkedHashSet<Address>();
        addresses.addAll(this.oldCH.locate(key, replCount));
        addresses.addAll(this.newCH.locate(key, replCount));
        return Immutables.immutableListConvert(addresses);
    }

    @Override
    public int getHashId(Address a) {
        throw new UnsupportedOperationException("Unsupported!");
    }

    @Override
    public List<Address> getStateProvidersOnLeave(Address leaver, int replCount) {
        throw new UnsupportedOperationException("Unsupported!");
    }

    @Override
    public List<Address> getStateProvidersOnJoin(Address joiner, int replCount) {
        throw new UnsupportedOperationException("Unsupported!");
    }

    @Override
    public List<Address> getBackupsForNode(Address node, int replCount) {
        return this.oldCH.locate(node, replCount);
    }

    @Override
    public int getHashSpace() {
        int newHashSpace;
        int oldHashSpace = this.oldCH.getHashSpace();
        return oldHashSpace > (newHashSpace = this.newCH.getHashSpace()) ? oldHashSpace : newHashSpace;
    }

    public ConsistentHash getNewConsistentHash() {
        return this.newCH;
    }

    public ConsistentHash getOldConsistentHash() {
        return this.oldCH;
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
            UnionConsistentHash uch = (UnionConsistentHash)object;
            output.writeObject(uch.oldCH);
            output.writeObject(uch.newCH);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new UnionConsistentHash((ConsistentHash)input.readObject(), (ConsistentHash)input.readObject());
        }
    }
}

