/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.lookup;

import java.lang.reflect.Method;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GenericTransactionManagerLookup
implements TransactionManagerLookup {
    private static final Log log = LogFactory.getLog(GenericTransactionManagerLookup.class);
    private static boolean lookupDone = false;
    private static boolean lookupFailed = false;
    private static TransactionManager tm = null;
    private static String[][] knownJNDIManagers = new String[][]{{"java:/TransactionManager", "JBoss, JRun4"}, {"java:comp/TransactionManager", "Resin 3.x"}, {"java:appserver/TransactionManager", "Sun Glassfish"}, {"java:pm/TransactionManager", "Borland, Sun"}, {"javax.transaction.TransactionManager", "BEA WebLogic"}, {"java:comp/UserTransaction", "Resin, Orion, JOnAS (JOTM)"}};
    private static final String WS_FACTORY_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";
    private static final String WS_FACTORY_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
    private static final String WS_FACTORY_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";

    @Override
    public TransactionManager getTransactionManager() {
        if (!lookupDone) {
            GenericTransactionManagerLookup.doLookups();
        }
        if (tm != null) {
            return tm;
        }
        if (lookupFailed) {
            tm = DummyTransactionManager.getInstance();
            log.warn("Falling back to DummyTransactionManager from Infinispan");
        }
        return tm;
    }

    private static void doLookups() {
        Class clazz;
        InitialContext ctx;
        if (lookupFailed) {
            return;
        }
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            log.error((Object)"Failed creating initial JNDI context", e);
            lookupFailed = true;
            return;
        }
        for (String[] knownJNDIManager : knownJNDIManagers) {
            Object jndiObject;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Trying to lookup TransactionManager for " + knownJNDIManager[1]);
                }
                jndiObject = ctx.lookup(knownJNDIManager[0]);
            }
            catch (NamingException e) {
                log.debug("Failed to perform a lookup for [" + knownJNDIManager[0] + " (" + knownJNDIManager[1] + ")]");
                continue;
            }
            if (!(jndiObject instanceof TransactionManager)) continue;
            tm = (TransactionManager)jndiObject;
            log.debug("Found TransactionManager for " + knownJNDIManager[1]);
            return;
        }
        try {
            log.debug("Trying WebSphere 5.1: com.ibm.ws.Transaction.TransactionManagerFactory");
            clazz = Util.loadClassStrict(WS_FACTORY_CLASS_5_1);
            log.debug("Found WebSphere 5.1: com.ibm.ws.Transaction.TransactionManagerFactory");
        }
        catch (ClassNotFoundException ex) {
            try {
                log.debug("Trying WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
                clazz = Util.loadClassStrict(WS_FACTORY_CLASS_5_0);
                log.debug("Found WebSphere 5.0: com.ibm.ejs.jts.jta.TransactionManagerFactory");
            }
            catch (ClassNotFoundException ex2) {
                try {
                    log.debug("Trying WebSphere 4: com.ibm.ejs.jts.jta.JTSXA");
                    clazz = Util.loadClassStrict(WS_FACTORY_CLASS_4);
                    log.debug("Found WebSphere 4: com.ibm.ejs.jts.jta.JTSXA");
                }
                catch (ClassNotFoundException ex3) {
                    log.debug("Couldn't find any WebSphere TransactionManager factory class, neither for WebSphere version 5.1 nor 5.0 nor 4");
                    lookupFailed = true;
                    return;
                }
            }
        }
        try {
            Class<?>[] signature = null;
            Object[] args = null;
            Method method = clazz.getMethod("getTransactionManager", signature);
            tm = (TransactionManager)method.invoke(null, args);
        }
        catch (Exception ex) {
            log.error((Object)("Found WebSphere TransactionManager factory class [" + clazz.getName() + "], but couldn't invoke its static 'getTransactionManager' method"), ex);
        }
    }
}

