/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import java.util.Collection;
import java.util.HashSet;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.transport.Address;

public class ClusteredGetResponseValidityFilter
implements ResponseFilter {
    private int numValidResponses = 0;
    private Collection<Address> pendingResponders;

    public ClusteredGetResponseValidityFilter(Collection<Address> pendingResponders) {
        this.pendingResponders = new HashSet<Address>(pendingResponders);
    }

    @Override
    public boolean isAcceptable(Response response, Address address) {
        this.pendingResponders.remove(address);
        if (response instanceof SuccessfulResponse) {
            ++this.numValidResponses;
        }
        return true;
    }

    @Override
    public boolean needMoreResponses() {
        return this.numValidResponses < 1 && !this.pendingResponders.isEmpty();
    }
}

