/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class FileLookup {
    private static final Log log = LogFactory.getLog(FileLookup.class);

    public InputStream lookupFile(String filename) {
        InputStream is;
        InputStream inputStream = is = filename == null || filename.length() == 0 ? null : this.getAsInputStreamFromClassLoader(filename);
        if (is == null) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to find file " + filename + " in classpath; searching for this file on the filesystem instead.");
            }
            try {
                is = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return is;
    }

    protected InputStream getAsInputStreamFromClassLoader(String filename) {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = is = cl == null ? null : cl.getResourceAsStream(filename);
        if (is == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(filename);
        }
        return is;
    }

    public URL lookupFileLocation(String filename) {
        File f;
        URL u;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL uRL = u = cl == null ? null : cl.getResource(filename);
        if (u == null) {
            u = this.getClass().getClassLoader().getResource(filename);
        }
        if (u == null && (f = new File(filename)).exists()) {
            try {
                u = f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return u;
    }
}

