/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.List;
import org.infinispan.CacheException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.NamedCacheNotFoundException;
import org.infinispan.remoting.ReplicationException;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;

public abstract class AbstractTransport
implements Transport {
    protected GlobalConfiguration configuration;

    @Override
    public void setConfiguration(GlobalConfiguration globalConfiguration) {
        this.configuration = globalConfiguration;
    }

    protected final boolean shouldThrowException(Exception ce) {
        if (!this.configuration.isStrictPeerToPeer()) {
            if (ce instanceof NamedCacheNotFoundException) {
                return false;
            }
            if (ce.getCause() != null && ce.getCause() instanceof NamedCacheNotFoundException) {
                return false;
            }
        }
        return true;
    }

    protected boolean parseResponseAndAddToResponseList(Object value, List<Response> retval, boolean wasSuspected, boolean wasReceived, Address sender, boolean usedResponseFilter) throws Exception {
        Log log = this.getLog();
        boolean trace = log.isTraceEnabled();
        boolean invalidResponse = true;
        if (wasSuspected || !wasReceived) {
            if (wasSuspected) {
                throw new SuspectException("Suspected member: " + sender);
            }
            if (usedResponseFilter) {
                throw new TimeoutException("Replication timeout for " + sender);
            }
        } else {
            invalidResponse = false;
            if (value instanceof Response) {
                Exception e;
                Response response = (Response)value;
                if (response instanceof ExceptionResponse && !((e = ((ExceptionResponse)value).getException()) instanceof ReplicationException)) {
                    if (this.shouldThrowException(e)) {
                        throw e;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Received exception from sender {0}", sender, e);
                    }
                }
                retval.add(response);
            } else {
                if (value instanceof Exception) {
                    Exception e = (Exception)value;
                    if (trace) {
                        log.trace((Object)("Unexpected exception from " + sender), e);
                    }
                    throw e;
                }
                if (value instanceof Throwable) {
                    Throwable t = (Throwable)value;
                    if (trace) {
                        log.trace((Object)("Unexpected throwable from " + sender), t);
                    }
                    throw new CacheException("Remote (" + sender + ") failed unexpectedly", t);
                }
            }
        }
        return invalidResponse;
    }
}

