/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.infinispan.CacheException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.distribution.ConsistentHashHelper;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.distribution.RehashTask;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JoinTask
extends RehashTask {
    private static final Log log = LogFactory.getLog(JoinTask.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Address self;

    public JoinTask(RpcManager rpcManager, CommandsFactory commandsFactory, Configuration conf, DataContainer dataContainer, DistributionManagerImpl dmi) {
        super(dmi, rpcManager, conf, commandsFactory, dataContainer);
        this.self = rpcManager.getTransport().getAddress();
    }

    private List<Address> parseResponses(List<Response> resp) {
        for (Response r : resp) {
            if (!(r instanceof SuccessfulResponse)) continue;
            return (List)((SuccessfulResponse)r).getResponseValue();
        }
        return null;
    }

    private Map<Object, InternalCacheValue> getStateFromResponse(SuccessfulResponse r) {
        return (Map)r.getResponseValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRehash() throws Exception {
        block20: {
            block19: {
                long start;
                long l = start = trace ? System.currentTimeMillis() : 0L;
                if (log.isDebugEnabled()) {
                    log.debug("Commencing rehash on node: " + this.getMyAddress() + ". Before start, dmi.joinComplete = " + this.dmi.isJoinComplete());
                }
                TransactionLogger transactionLogger = this.dmi.getTransactionLogger();
                boolean unlocked = false;
                try {
                    if (this.dmi.isJoinComplete()) {
                        throw new IllegalStateException("Join cannot be complete without rehash to finish (node " + this.getMyAddress() + " )");
                    }
                    ConsistentHash chOld = this.retrieveOldCH(trace);
                    ConsistentHash chNew = chOld.getCaches().contains(this.self) ? chOld : ConsistentHashHelper.createConsistentHash(this.configuration, chOld.getCaches(), this.self);
                    this.dmi.setConsistentHash(chNew);
                    try {
                        if (this.configuration.isRehashEnabled()) {
                            transactionLogger.enable();
                            this.rpcManager.broadcastRpcCommand(this.cf.buildRehashControlCommand(RehashControlCommand.Type.JOIN_REHASH_START, this.self), true, true);
                            Address myAddress = this.rpcManager.getTransport().getAddress();
                            RehashControlCommand cmd = this.cf.buildRehashControlCommand(RehashControlCommand.Type.PULL_STATE_JOIN, myAddress, null, chOld, chNew, null);
                            List<Address> addressesWhoMaySendStuff = this.getAddressesWhoMaySendStuff(chNew, this.configuration.getNumOwners());
                            List<Response> resps = this.rpcManager.invokeRemotely(addressesWhoMaySendStuff, cmd, ResponseMode.SYNCHRONOUS, this.configuration.getRehashRpcTimeout(), true);
                            for (Response r : resps) {
                                if (!(r instanceof SuccessfulResponse)) continue;
                                Map<Object, InternalCacheValue> state = this.getStateFromResponse((SuccessfulResponse)r);
                                this.dmi.applyState(chNew, state);
                            }
                            this.dmi.drainLocalTransactionLog();
                            unlocked = true;
                        } else {
                            this.rpcManager.broadcastRpcCommand(this.cf.buildRehashControlCommand(RehashControlCommand.Type.JOIN_REHASH_START, this.self), true, true);
                            if (trace) {
                                log.trace("Rehash not enabled, so not pulling state.");
                            }
                        }
                    }
                    finally {
                        this.rpcManager.broadcastRpcCommand(this.cf.buildRehashControlCommand(RehashControlCommand.Type.JOIN_REHASH_END, this.self), true, true);
                        if (this.configuration.isRehashEnabled()) {
                            this.invalidateInvalidHolders(chOld, chNew);
                        }
                    }
                    if (!unlocked) {
                        transactionLogger.unlockAndDisable();
                    }
                    this.dmi.setJoinComplete(true);
                    if (!trace) break block19;
                }
                catch (Exception e) {
                    try {
                        log.error((Object)"Caught exception!", e);
                        throw new CacheException("Unexpected exception", e);
                    }
                    catch (Throwable throwable) {
                        if (!unlocked) {
                            transactionLogger.unlockAndDisable();
                        }
                        this.dmi.setJoinComplete(true);
                        if (trace) {
                            log.info((Object)"{0} completed join rehash in {1}!", this.self, Util.prettyPrintTime(System.currentTimeMillis() - start));
                        } else {
                            log.info((Object)"{0} completed join rehash!", this.self);
                        }
                        throw throwable;
                    }
                }
                log.info((Object)"{0} completed join rehash in {1}!", this.self, Util.prettyPrintTime(System.currentTimeMillis() - start));
                break block20;
            }
            log.info((Object)"{0} completed join rehash!", this.self);
        }
    }

    private ConsistentHash retrieveOldCH(boolean trace) throws InterruptedException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        ConsistentHash result = null;
        long minSleepTime = 500L;
        long maxSleepTime = 2000L;
        int maxWaitTime = (int)this.configuration.getRehashRpcTimeout() * 10;
        Random rand = new Random();
        long giveupTime = System.currentTimeMillis() + (long)maxWaitTime;
        do {
            List<Address> addresses;
            block8: {
                List<Response> resp;
                if (trace) {
                    log.trace("Requesting old consistent hash from coordinator");
                }
                try {
                    resp = this.rpcManager.invokeRemotely(this.coordinator(), this.cf.buildRehashControlCommand(RehashControlCommand.Type.JOIN_REQ, this.self), ResponseMode.SYNCHRONOUS, this.configuration.getRehashRpcTimeout(), true);
                    addresses = this.parseResponses(resp);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Retrieved old consistent hash address list {0}", addresses);
                    }
                }
                catch (TimeoutException te) {
                    resp = null;
                    addresses = null;
                    if (!log.isDebugEnabled()) break block8;
                    log.debug("Timed out waiting for responses.");
                }
            }
            if (addresses == null) {
                long time = rand.nextInt((int)(maxSleepTime - minSleepTime) / 10);
                time = time * 10L + minSleepTime;
                if (trace) {
                    log.trace((Object)"Sleeping for {0}", Util.prettyPrintTime(time));
                }
                Thread.sleep(time);
                continue;
            }
            result = ConsistentHashHelper.createConsistentHash(this.configuration, addresses);
        } while (result == null && System.currentTimeMillis() < giveupTime);
        if (result == null) {
            throw new CacheException("Unable to retrieve old consistent hash from coordinator even after several attempts at sleeping and retrying!");
        }
        return result;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    List<Address> getAddressesWhoMaySendStuff(ConsistentHash ch, int replCount) {
        LinkedList<Address> l = new LinkedList<Address>();
        List<Address> caches = ch.getCaches();
        int selfIdx = caches.indexOf(this.self);
        if (selfIdx >= replCount - 1) {
            l.addAll(caches.subList(selfIdx - replCount + 1, selfIdx));
        } else {
            l.addAll(caches.subList(0, selfIdx));
            int alreadyCollected = l.size();
            l.addAll(caches.subList(caches.size() - replCount + 1 + alreadyCollected, caches.size()));
        }
        Address plusOne = selfIdx == caches.size() - 1 ? caches.get(0) : caches.get(selfIdx + 1);
        if (!l.contains(plusOne)) {
            l.add(plusOne);
        }
        return l;
    }

    public Address getMyAddress() {
        return this.rpcManager != null && this.rpcManager.getTransport() != null ? this.rpcManager.getTransport().getAddress() : null;
    }
}

