/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.util.concurrent.NotifyingFutureImpl;

public class ReplicationInterceptor
extends BaseRpcInterceptor {
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!ctx.isInTxScope()) {
            throw new IllegalStateException("This should not be possible!");
        }
        if (ctx.isOriginLocal()) {
            this.rpcManager.broadcastRpcCommand(command, this.configuration.isSyncCommitPhase(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (ctx.isOriginLocal() && command.hasModifications()) {
            boolean async = this.configuration.getCacheMode() == Configuration.CacheMode.REPL_ASYNC;
            this.rpcManager.broadcastRpcCommand(command, !async, false);
        }
        return retVal;
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (ctx.isOriginLocal() && !this.configuration.isOnePhaseCommit()) {
            this.rpcManager.broadcastRpcCommand(command, this.configuration.isSyncRollbackPhase(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    private Object handleCrudMethod(InvocationContext ctx, WriteCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (!this.isLocalModeForced(ctx) && command.isSuccessful() && ctx.isOriginLocal() && !ctx.isInTxScope()) {
            if (ctx.isUseFutureReturnType()) {
                NotifyingFutureImpl future = new NotifyingFutureImpl(returnValue);
                this.rpcManager.broadcastRpcCommandInFuture(command, future);
                return future;
            }
            this.rpcManager.broadcastRpcCommand(command, this.isSynchronous(ctx));
        }
        return returnValue;
    }
}

