/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.util.Immutables;
import org.infinispan.util.concurrent.BoundedConcurrentHashMap;

@ThreadSafe
public class DefaultDataContainer
implements DataContainer {
    final ConcurrentMap<Object, InternalCacheEntry> entries;
    final InternalEntryFactory entryFactory;
    final DefaultEvictionListener evictionListener;
    private EvictionManager evictionManager;

    protected DefaultDataContainer(int concurrencyLevel) {
        this.entries = new ConcurrentHashMap<Object, InternalCacheEntry>(128, 0.75f, concurrencyLevel);
        this.entryFactory = new InternalEntryFactory();
        this.evictionListener = null;
    }

    protected DefaultDataContainer(int concurrencyLevel, int maxEntries, EvictionStrategy strategy, EvictionThreadPolicy policy) {
        BoundedConcurrentHashMap.Eviction eviction;
        switch (policy) {
            case PIGGYBACK: 
            case DEFAULT: {
                this.evictionListener = new DefaultEvictionListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("No such eviction thread policy " + (Object)((Object)strategy));
            }
        }
        switch (strategy) {
            case FIFO: 
            case UNORDERED: 
            case LRU: {
                eviction = BoundedConcurrentHashMap.Eviction.LRU;
                break;
            }
            case LIRS: {
                eviction = BoundedConcurrentHashMap.Eviction.LIRS;
                break;
            }
            default: {
                throw new IllegalArgumentException("No such eviction strategy " + (Object)((Object)strategy));
            }
        }
        this.entries = new BoundedConcurrentHashMap<Object, InternalCacheEntry>(maxEntries, concurrencyLevel, eviction, this.evictionListener);
        this.entryFactory = new InternalEntryFactory();
    }

    @Inject
    public void initialize(EvictionManager evictionManager) {
        this.evictionManager = evictionManager;
    }

    public static DataContainer boundedDataContainer(int concurrencyLevel, int maxEntries, EvictionStrategy strategy, EvictionThreadPolicy policy) {
        return new DefaultDataContainer(concurrencyLevel, maxEntries, strategy, policy);
    }

    public static DataContainer unBoundedDataContainer(int concurrencyLevel) {
        return new DefaultDataContainer(concurrencyLevel);
    }

    @Override
    public InternalCacheEntry peek(Object key) {
        InternalCacheEntry e = (InternalCacheEntry)this.entries.get(key);
        return e;
    }

    @Override
    public InternalCacheEntry get(Object k) {
        InternalCacheEntry e = this.peek(k);
        if (e != null) {
            if (e.isExpired()) {
                this.entries.remove(k);
                e = null;
            } else {
                e.touch();
            }
        }
        return e;
    }

    @Override
    public void put(Object k, Object v, long lifespan, long maxIdle) {
        InternalCacheEntry e = (InternalCacheEntry)this.entries.get(k);
        if (e != null) {
            e.setValue(v);
            InternalCacheEntry original = e;
            e = this.entryFactory.update(e, lifespan, maxIdle);
            if (original == e) {
                e.reincarnate();
            }
        } else {
            e = this.entryFactory.createNewEntry(k, v, lifespan, maxIdle);
        }
        this.entries.put(k, e);
    }

    @Override
    public boolean containsKey(Object k) {
        InternalCacheEntry ice = this.peek(k);
        if (ice != null && ice.isExpired()) {
            this.entries.remove(k);
            ice = null;
        }
        return ice != null;
    }

    @Override
    public InternalCacheEntry remove(Object k) {
        InternalCacheEntry e = (InternalCacheEntry)this.entries.remove(k);
        return e == null || e.isExpired() ? null : e;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Set<Object> keySet() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    @Override
    public Collection<Object> values() {
        return new Values();
    }

    @Override
    public Set<InternalCacheEntry> entrySet() {
        return new EntrySet();
    }

    @Override
    public void purgeExpired() {
        Iterator purgeCandidates = this.entries.values().iterator();
        while (purgeCandidates.hasNext()) {
            InternalCacheEntry e = (InternalCacheEntry)purgeCandidates.next();
            if (!e.isExpired()) continue;
            purgeCandidates.remove();
        }
    }

    @Override
    public Iterator<InternalCacheEntry> iterator() {
        return new EntryIterator(this.entries.values().iterator());
    }

    private static class ValueIterator
    implements Iterator<Object> {
        Iterator<InternalCacheEntry> currentIterator;

        private ValueIterator(Iterator<InternalCacheEntry> it) {
            this.currentIterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object next() {
            return this.currentIterator.next().getValue();
        }
    }

    private class Values
    extends AbstractCollection<Object> {
        private Values() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValueIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }
    }

    private class EntrySet
    extends AbstractSet<InternalCacheEntry> {
        private EntrySet() {
        }

        @Override
        public Iterator<InternalCacheEntry> iterator() {
            return new ImmutableEntryIterator(DefaultDataContainer.this.entries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.entries.size();
        }
    }

    public static class EntryIterator
    implements Iterator<InternalCacheEntry> {
        private final Iterator<InternalCacheEntry> it;

        EntryIterator(Iterator<InternalCacheEntry> it) {
            this.it = it;
        }

        @Override
        public InternalCacheEntry next() {
            return this.it.next();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ImmutableEntryIterator
    extends EntryIterator {
        ImmutableEntryIterator(Iterator<InternalCacheEntry> it) {
            super(it);
        }

        @Override
        public InternalCacheEntry next() {
            return Immutables.immutableInternalCacheEntry(super.next());
        }
    }

    private class DefaultEvictionListener
    implements BoundedConcurrentHashMap.EvictionListener<Object, InternalCacheEntry> {
        private DefaultEvictionListener() {
        }

        @Override
        public void preEvict(Object key) {
            DefaultDataContainer.this.evictionManager.preEvict(key);
        }

        @Override
        public void postEvict(Object key, InternalCacheEntry value) {
            DefaultDataContainer.this.evictionManager.postEvict(key, value);
        }
    }
}

