/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.Locale;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.infinispan.config.AbstractNamedCacheConfigurationBean;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.util.TypedProperties;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="interceptor")
public class CustomInterceptorConfig
extends AbstractNamedCacheConfigurationBean {
    private static final long serialVersionUID = 6206233611032238190L;
    @XmlTransient
    protected CommandInterceptor interceptor;
    @XmlTransient
    protected boolean isFirst;
    @XmlTransient
    protected boolean isLast;
    @XmlAttribute
    protected Integer index = -1;
    @XmlAttribute
    protected String after;
    @XmlAttribute
    protected String before;
    @XmlAttribute
    protected Position position;
    @XmlAttribute(name="class")
    protected String className;
    @XmlElement
    private TypedProperties properties = EMPTY_PROPERTIES;

    public CustomInterceptorConfig() {
    }

    public CustomInterceptorConfig(CommandInterceptor interceptor, boolean first, boolean last, int index, String after, String before) {
        this.interceptor = interceptor;
        this.isFirst = first;
        this.isLast = last;
        this.index = index;
        this.after = after;
        this.before = before;
        this.overriddenConfigurationElements.add("interceptor");
        this.overriddenConfigurationElements.add("isFirst");
        this.overriddenConfigurationElements.add("isLast");
        this.overriddenConfigurationElements.add("index");
        this.overriddenConfigurationElements.add("after");
        this.overriddenConfigurationElements.add("before");
    }

    public CustomInterceptorConfig(CommandInterceptor interceptor, boolean first, boolean last, int index, Class<? extends CommandInterceptor> after, Class<? extends CommandInterceptor> before) {
        this.interceptor = interceptor;
        this.isFirst = first;
        this.isLast = last;
        this.index = index;
        this.overriddenConfigurationElements.add("interceptor");
        this.overriddenConfigurationElements.add("isFirst");
        this.overriddenConfigurationElements.add("isLast");
        this.overriddenConfigurationElements.add("index");
        if (after != null) {
            this.after = after.getName();
            this.overriddenConfigurationElements.add("after");
        }
        if (before != null) {
            this.before = before.getName();
            this.overriddenConfigurationElements.add("before");
        }
    }

    public CustomInterceptorConfig(CommandInterceptor interceptor) {
        this.interceptor = interceptor;
        this.overriddenConfigurationElements.add("interceptor");
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = this.toTypedProperties(properties);
        this.testImmutability("properties");
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
        this.testImmutability("position");
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
        this.testImmutability("className");
    }

    public void setFirst(boolean first) {
        this.testImmutability("first");
        this.isFirst = first;
    }

    public void setLast(boolean last) {
        this.testImmutability("last");
        this.isLast = last;
    }

    public void setPosition(String pos) {
        this.setPosition(Position.valueOf(this.uc(pos)));
    }

    public void setIndex(int index) {
        this.testImmutability("index");
        this.index = index;
    }

    public void setAfterInterceptor(String afterClass) {
        this.testImmutability("after");
        this.after = afterClass;
    }

    public void setAfterInterceptor(Class<? extends CommandInterceptor> interceptorClass) {
        this.setAfterInterceptor(interceptorClass.getName());
    }

    public void setBeforeInterceptor(String beforeClass) {
        this.testImmutability("before");
        this.before = beforeClass;
    }

    public void setBeforeInterceptor(Class<? extends CommandInterceptor> interceptorClass) {
        this.setBeforeInterceptor(interceptorClass.getName());
    }

    public CommandInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(CommandInterceptor interceptor) {
        this.testImmutability("interceptor");
        this.interceptor = interceptor;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public int getIndex() {
        return this.index;
    }

    public String getAfter() {
        return this.after;
    }

    public String getBefore() {
        return this.before;
    }

    public String toString() {
        return "CustomInterceptorConfig{interceptor='" + this.interceptor + '\'' + ", isFirst=" + this.isFirst + ", isLast=" + this.isLast + ", index=" + this.index + ", after='" + this.after + '\'' + ", before='" + this.before + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomInterceptorConfig)) {
            return false;
        }
        CustomInterceptorConfig that = (CustomInterceptorConfig)o;
        if (this.index != null && !this.index.equals(that.index)) {
            return false;
        }
        if (this.isFirst != that.isFirst) {
            return false;
        }
        if (this.isLast != that.isLast) {
            return false;
        }
        if (this.after != null ? !this.after.equals(that.after) : that.after != null) {
            return false;
        }
        if (this.before != null ? !this.before.equals(that.before) : that.before != null) {
            return false;
        }
        return !(this.interceptor != null ? !this.interceptor.equals(that.interceptor) : that.interceptor != null);
    }

    public int hashCode() {
        int result = this.interceptor != null ? this.interceptor.hashCode() : 0;
        result = 31 * result + (this.isFirst ? 1 : 0);
        result = 31 * result + (this.isLast ? 1 : 0);
        result = 31 * result + this.index;
        result = 31 * result + (this.after != null ? this.after.hashCode() : 0);
        result = 31 * result + (this.before != null ? this.before.hashCode() : 0);
        return result;
    }

    @Override
    public CustomInterceptorConfig clone() throws CloneNotSupportedException {
        CustomInterceptorConfig dolly = (CustomInterceptorConfig)super.clone();
        if (this.properties != null) {
            dolly.properties = (TypedProperties)this.properties.clone();
        }
        return dolly;
    }

    @Override
    protected String uc(String s) {
        return s == null ? null : s.toUpperCase(Locale.ENGLISH);
    }

    public void accept(ConfigurationBeanVisitor v) {
        v.visitCustomInterceptorConfig(this);
    }

    static enum Position {
        FIRST,
        LAST;

    }
}

