/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan;

import net.jcip.annotations.Immutable;

@Immutable
public class Version {
    public static final String version = "4.2.0.ALPHA3";
    public static final String codename = "Pagoa";
    public static final String projectName = "Infinispan";
    static final byte[] version_id = new byte[]{52, 50, 48, 65, 76, 80, 72, 65, 51};
    private static final int MAJOR_SHIFT = 11;
    private static final int MINOR_SHIFT = 6;
    private static final int MAJOR_MASK = 63488;
    private static final int MINOR_MASK = 1984;
    private static final int PATCH_MASK = 63;

    public static void main(String[] args) {
        Version.printFullVersionInformation();
    }

    public static void printFullVersionInformation() {
        System.out.println(projectName);
        System.out.println();
        System.out.println("\nVersion: \t4.2.0.ALPHA3");
        System.out.println("Codename: \tPagoa");
        System.out.println("History:  \t(see https://jira.jboss.org/jira/browse/ISPN for details)\n");
    }

    public static String printVersion() {
        return "Infinispan 'Pagoa' 4.2.0.ALPHA3";
    }

    public static String printVersionId(byte[] v, int len) {
        StringBuilder sb = new StringBuilder();
        if (v != null) {
            if (len <= 0) {
                len = v.length;
            }
            for (int i = 0; i < len; ++i) {
                sb.append((char)v[i]);
            }
        }
        return sb.toString();
    }

    public static String printVersionId(byte[] v) {
        StringBuilder sb = new StringBuilder();
        if (v != null) {
            for (byte aV : v) {
                sb.append((char)aV);
            }
        }
        return sb.toString();
    }

    public static boolean compareTo(byte[] v) {
        if (v == null) {
            return false;
        }
        if (v.length < version_id.length) {
            return false;
        }
        for (int i = 0; i < version_id.length; ++i) {
            if (version_id[i] == v[i]) continue;
            return false;
        }
        return true;
    }

    public static int getLength() {
        return version_id.length;
    }

    public static short getVersionShort() {
        return Version.getVersionShort(version);
    }

    public static short getVersionShort(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("versionString is null");
        }
        String[] parts = Version.getParts(versionString);
        int a = 0;
        int b = 0;
        int c = 0;
        if (parts.length > 0) {
            a = Integer.parseInt(parts[0]);
        }
        if (parts.length > 1) {
            b = Integer.parseInt(parts[1]);
        }
        if (parts.length > 2) {
            c = Integer.parseInt(parts[2]);
        }
        return Version.encodeVersion(a, b, c);
    }

    public static short encodeVersion(int major, int minor, int patch) {
        return (short)((major << 11) + (minor << 6) + patch);
    }

    public static String decodeVersion(short version) {
        int major = (version & 0xF800) >> 11;
        int minor = (version & 0x7C0) >> 6;
        int patch = version & 0x3F;
        return major + "." + minor + "." + patch;
    }

    public static String decodeVersionForSerialization(short version) {
        int major = (version & 0xF800) >> 11;
        int minor = (version & 0x7C0) >> 6;
        return major + "." + minor;
    }

    private static String[] getParts(String versionString) {
        return versionString.split("[\\.\\-]");
    }

    public static String getMajorVersion() {
        String[] parts = Version.getParts(version);
        return parts[0] + "." + parts[1];
    }
}

