/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheSupport;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.stats.Stats;
import org.infinispan.stats.StatsImpl;
import org.infinispan.util.concurrent.AbstractInProcessNotifyingFuture;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.DisplayType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;

@SurvivesRestarts
@MBean(objectName="Cache", description="Component that acts as a manager, factory and container for caches in the system.")
public class CacheDelegate<K, V>
extends CacheSupport<K, V>
implements AdvancedCache<K, V> {
    public static final String OBJECT_NAME = "Cache";
    protected InvocationContextContainer icc;
    protected CommandsFactory commandsFactory;
    protected InterceptorChain invoker;
    protected Configuration config;
    protected CacheNotifier notifier;
    protected BatchContainer batchContainer;
    protected ComponentRegistry componentRegistry;
    protected TransactionManager transactionManager;
    protected RpcManager rpcManager;
    protected StreamingMarshaller marshaller;
    private String name;
    private EvictionManager evictionManager;
    private DataContainer dataContainer;
    private static final Log log = LogFactory.getLog(CacheDelegate.class);
    private EmbeddedCacheManager cacheManager;
    private StateTransferManager stateTransferManager;
    private ResponseGenerator responseGenerator;
    private DistributionManager distributionManager;
    private ThreadLocal<PreInvocationContext> flagHolder = new ThreadLocal();

    public CacheDelegate(String name) {
        this.name = name;
    }

    @Inject
    public void injectDependencies(EvictionManager evictionManager, InvocationContextContainer icc, CommandsFactory commandsFactory, InterceptorChain interceptorChain, Configuration configuration, CacheNotifier notifier, ComponentRegistry componentRegistry, TransactionManager transactionManager, BatchContainer batchContainer, RpcManager rpcManager, DataContainer dataContainer, StreamingMarshaller marshaller, ResponseGenerator responseGenerator, DistributionManager distributionManager, EmbeddedCacheManager cacheManager, StateTransferManager stateTransferManager) {
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
        this.config = configuration;
        this.notifier = notifier;
        this.componentRegistry = componentRegistry;
        this.transactionManager = transactionManager;
        this.batchContainer = batchContainer;
        this.rpcManager = rpcManager;
        this.evictionManager = evictionManager;
        this.dataContainer = dataContainer;
        this.marshaller = marshaller;
        this.cacheManager = cacheManager;
        this.responseGenerator = responseGenerator;
        this.stateTransferManager = stateTransferManager;
        this.icc = icc;
        this.distributionManager = distributionManager;
    }

    private void assertKeyNotNull(Object key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not supported!");
        }
    }

    private void assertKeysNotNull(Map<?, ?> data) {
        if (data == null) {
            throw new NullPointerException("Expected map cannot be null");
        }
        for (Object key : data.keySet()) {
            if (key != null) continue;
            throw new NullPointerException("Null keys are not supported!");
        }
    }

    @Override
    public final boolean remove(Object key, Object value) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, value);
        return (Boolean)this.invoker.invoke(ctx, command);
    }

    @Override
    public final int size() {
        SizeCommand command = this.commandsFactory.buildSizeCommand();
        return (Integer)this.invoker.invoke(this.icc.createNonTxInvocationContext(), command);
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean containsKey(Object key) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key);
        Object response = this.invoker.invoke(ctx, command);
        return response != null;
    }

    @Override
    public final boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public final V get(Object key) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key);
        return (V)this.invoker.invoke(ctx, command);
    }

    @Override
    public final V remove(Object key) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, null);
        return (V)this.invoker.invoke(ctx, command);
    }

    @Override
    public final void clear() {
        InvocationContext ctx = this.getInvocationContext(false);
        ClearCommand command = this.commandsFactory.buildClearCommand();
        this.invoker.invoke(ctx, command);
    }

    @Override
    public Set<K> keySet() {
        KeySetCommand command = this.commandsFactory.buildKeySetCommand();
        return (Set)this.invoker.invoke(this.icc.createNonTxInvocationContext(), command);
    }

    @Override
    public Collection<V> values() {
        ValuesCommand command = this.commandsFactory.buildValuesCommand();
        return (Collection)this.invoker.invoke(this.icc.createNonTxInvocationContext(), command);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetCommand command = this.commandsFactory.buildEntrySetCommand();
        return (Set)this.invoker.invoke(this.icc.createNonTxInvocationContext(), command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void putForExternalRead(K key, V value) {
        Transaction ongoingTransaction = null;
        try {
            if (this.transactionManager != null && (ongoingTransaction = this.transactionManager.getTransaction()) != null) {
                this.transactionManager.suspend();
            }
            this.withFlags(Flag.FAIL_SILENTLY, Flag.FORCE_ASYNCHRONOUS, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.PUT_FOR_EXTERNAL_READ).putIfAbsent(key, value);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Caught exception while doing putForExternalRead()", e);
            }
        }
        finally {
            try {
                if (ongoingTransaction != null) {
                    this.transactionManager.resume(ongoingTransaction);
                }
            }
            catch (Exception e) {
                log.debug((Object)"Had problems trying to resume a transaction after putForExternalRead()", e);
            }
        }
    }

    @Override
    public final void evict(K key) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(true);
        EvictCommand command = this.commandsFactory.buildEvictCommand(key);
        this.invoker.invoke(ctx, command);
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void addListener(Object listener) {
        this.notifier.addListener(listener);
    }

    @Override
    public void removeListener(Object listener) {
        this.notifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        return this.notifier.getListeners();
    }

    private InvocationContext getInvocationContext(boolean forceNonTransactional) {
        InvocationContext ctx = forceNonTransactional ? this.icc.createNonTxInvocationContext() : this.icc.createInvocationContext();
        PreInvocationContext pic = this.flagHolder.get();
        if (pic != null && !pic.flags.isEmpty()) {
            ctx.setFlags(pic.flags);
        }
        this.flagHolder.remove();
        return ctx;
    }

    @Override
    public boolean lock(K key) {
        this.assertKeyNotNull(key);
        return this.lock((Collection<? extends K>)Collections.singletonList(key));
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("Cannot lock empty list of keys");
        }
        LockControlCommand command = this.commandsFactory.buildLockControlCommand(keys, false);
        return (Boolean)this.invoker.invoke(this.getInvocationContext(false), command);
    }

    @Override
    @ManagedOperation(description="Starts the cache.")
    @Operation(displayName="Starts cache.")
    public void start() {
        this.componentRegistry.start();
        this.defaultLifespan = this.config.getExpirationLifespan();
        this.defaultMaxIdleTime = this.config.getExpirationMaxIdle();
    }

    @Override
    @ManagedOperation(description="Stops the cache.")
    @Operation(displayName="Stops cache.")
    public void stop() {
        this.componentRegistry.stop();
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        return this.invoker.asList();
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        this.invoker.addInterceptor(i, position);
    }

    @Override
    public void addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        this.invoker.addInterceptorAfter(i, afterInterceptor);
    }

    @Override
    public void addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
        this.invoker.addInterceptorBefore(i, beforeInterceptor);
    }

    @Override
    public void removeInterceptor(int position) {
        this.invoker.removeInterceptor(position);
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.invoker.removeInterceptor(interceptorType);
    }

    @Override
    public EvictionManager getEvictionManager() {
        return this.evictionManager;
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.distributionManager;
    }

    @Override
    public ComponentStatus getStatus() {
        return this.componentRegistry.getStatus();
    }

    @ManagedAttribute(description="Returns the cache status")
    @Metric(displayName="Cache status", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheStatus() {
        return this.getStatus().toString();
    }

    @Override
    public boolean startBatch() {
        if (!this.config.isInvocationBatchingEnabled()) {
            throw new ConfigurationException("Invocation batching not enabled in current configuration!  Please use the <invocationBatching /> element.");
        }
        return this.batchContainer.startBatch();
    }

    @Override
    public void endBatch(boolean successful) {
        if (!this.config.isInvocationBatchingEnabled()) {
            throw new ConfigurationException("Invocation batching not enabled in current configuration!  Please use the <invocationBatching /> element.");
        }
        this.batchContainer.endBatch(successful);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @ManagedAttribute(description="Returns the cache name")
    @Metric(displayName="Cache name", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheName() {
        return this.getName().equals("___defaultcache") ? "Default Cache" : this.getName();
    }

    @Override
    public String getVersion() {
        return "4.2.0.ALPHA3";
    }

    public String toString() {
        return "Cache '" + this.name + "'@" + (this.config.getCacheMode().isClustered() ? this.getCacheManager().getAddress() : Integer.valueOf(System.identityHashCode(this)));
    }

    @Override
    public BatchContainer getBatchContainer() {
        return this.batchContainer;
    }

    @Override
    public InvocationContextContainer getInvocationContextContainer() {
        return this.icc;
    }

    @Override
    public DataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public Stats getStats() {
        return new StatsImpl(this.invoker);
    }

    @Override
    public final V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime));
        return (V)this.invoker.invoke(ctx, command);
    }

    @Override
    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        this.assertKeyNotNull(key);
        InvocationContext context = this.getInvocationContext(false);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime));
        command.setPutIfAbsent(true);
        return (V)this.invoker.invoke(context, command);
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        this.assertKeysNotNull(map);
        PutMapCommand command = this.commandsFactory.buildPutMapCommand(map, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime));
        this.invoker.invoke(this.getInvocationContext(false), command);
    }

    @Override
    public final V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, null, value, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime));
        return (V)this.invoker.invoke(ctx, command);
    }

    @Override
    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, oldValue, value, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime));
        return (Boolean)this.invoker.invoke(ctx, command);
    }

    private <X> NotifyingFuture<X> wrapInFuture(final Object retval) {
        if (retval instanceof NotifyingFuture) {
            return (NotifyingFuture)retval;
        }
        return new AbstractInProcessNotifyingFuture<X>(){

            @Override
            public X get() throws InterruptedException, ExecutionException {
                return retval;
            }
        };
    }

    @Override
    public final NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        ctx.setUseFutureReturnType(true);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.assertKeysNotNull(data);
        InvocationContext ctx = this.getInvocationContext(false);
        ctx.setUseFutureReturnType(true);
        PutMapCommand command = this.commandsFactory.buildPutMapCommand(data, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<Void> clearAsync() {
        InvocationContext ctx = this.getInvocationContext(false);
        ctx.setUseFutureReturnType(true);
        ClearCommand command = this.commandsFactory.buildClearCommand();
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        ctx.setUseFutureReturnType(true);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        command.setPutIfAbsent(true);
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<V> removeAsync(Object key) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        ctx.setUseFutureReturnType(true);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, null);
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<Boolean> removeAsync(Object key, Object value) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        ctx.setUseFutureReturnType(true);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, value);
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        ctx.setUseFutureReturnType(true);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, null, value, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContext(false);
        ctx.setUseFutureReturnType(true);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, oldValue, newValue, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle));
        return this.wrapInFuture(this.invoker.invoke(ctx, command));
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public void compact() {
        for (InternalCacheEntry e : this.dataContainer) {
            if (e.getKey() instanceof MarshalledValue) {
                ((MarshalledValue)e.getKey()).compact(true, true);
            }
            if (!(e.getValue() instanceof MarshalledValue)) continue;
            ((MarshalledValue)e.getValue()).compact(true, true);
        }
    }

    @Override
    public RpcManager getRpcManager() {
        return this.rpcManager;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        if (flags != null && flags.length > 0) {
            PreInvocationContext pic = this.flagHolder.get();
            if (pic == null) {
                this.flagHolder.set(new PreInvocationContext(flags));
            } else {
                this.flagHolder.set(pic.add(flags));
            }
        }
        return this;
    }

    private static final class PreInvocationContext {
        EnumSet<Flag> flags;

        private PreInvocationContext(Flag[] flags) {
            this.flags = flags != null && flags.length > 0 ? EnumSet.copyOf(Arrays.asList(flags)) : EnumSet.noneOf(Flag.class);
        }

        private PreInvocationContext add(Flag[] newFlags) {
            if (newFlags != null && newFlags.length > 0) {
                this.flags.addAll(Arrays.asList(newFlags));
            }
            return this;
        }
    }
}

