/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;

public abstract class AbstractInvocationContext
implements InvocationContext {
    protected volatile EnumSet<Flag> flags;
    protected byte contextFlags = 0;

    protected final boolean isContextFlagSet(ContextFlag flag) {
        return (this.contextFlags & flag.mask) != 0;
    }

    protected final void setContextFlag(ContextFlag flag) {
        this.contextFlags = (byte)(this.contextFlags | flag.mask);
    }

    protected final void unsetContextFlag(ContextFlag flag) {
        this.contextFlags = (byte)(this.contextFlags & ~flag.mask);
    }

    protected final void setContextFlag(ContextFlag flag, boolean set) {
        if (set) {
            this.setContextFlag(flag);
        } else {
            this.unsetContextFlag(flag);
        }
    }

    @Override
    public boolean hasFlag(Flag o) {
        return this.flags != null && this.flags.contains((Object)o);
    }

    @Override
    public Set<Flag> getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(Flag ... flags) {
        if (flags == null || flags.length == 0) {
            return;
        }
        if (this.flags == null) {
            this.flags = EnumSet.copyOf(Arrays.asList(flags));
        } else {
            this.flags.addAll(Arrays.asList(flags));
        }
    }

    @Override
    public void setFlags(Collection<Flag> flags) {
        if (flags == null || flags.isEmpty()) {
            return;
        }
        if (this.flags == null) {
            this.flags = EnumSet.copyOf(flags);
        } else {
            this.flags.addAll(flags);
        }
    }

    @Override
    public void reset() {
        this.flags = null;
        this.contextFlags = 0;
    }

    @Override
    public boolean isFlagsUninitialized() {
        return this.flags == null;
    }

    @Override
    public boolean hasLockedKey(Object key) {
        CacheEntry e = this.lookupEntry(key);
        if (e == null) {
            return this.getLookedUpEntries().containsKey(key);
        }
        return e.isChanged();
    }

    @Override
    public boolean isUseFutureReturnType() {
        return this.isContextFlagSet(ContextFlag.USE_FUTURE_RETURN_TYPE);
    }

    @Override
    public void setUseFutureReturnType(boolean useFutureReturnType) {
        this.setContextFlag(ContextFlag.USE_FUTURE_RETURN_TYPE, useFutureReturnType);
    }

    @Override
    public AbstractInvocationContext clone() {
        try {
            AbstractInvocationContext dolly = (AbstractInvocationContext)super.clone();
            if (this.flags != null) {
                dolly.flags = this.flags.clone();
            }
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!");
        }
    }

    @Override
    public Set getLockedKeys() {
        HashSet result = new HashSet();
        for (Object e : this.getLookedUpEntries().keySet()) {
            if (!this.hasLockedKey(e)) continue;
            result.add(e);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "flags=" + this.flags + '}';
    }

    protected static enum ContextFlag {
        USE_FUTURE_RETURN_TYPE(1),
        ORIGIN_LOCAL(2);

        final byte mask;

        private ContextFlag(int mask) {
            this.mask = (byte)mask;
        }
    }
}

