/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalEntryFactory;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.util.Immutables;
import org.infinispan.util.concurrent.BoundedConcurrentHashMap;

@ThreadSafe
public class DefaultDataContainer
implements DataContainer {
    final ConcurrentMap<Object, InternalCacheEntry> immortalEntries;
    final ConcurrentMap<Object, InternalCacheEntry> mortalEntries;
    final AtomicInteger numEntries = new AtomicInteger(0);
    final InternalEntryFactory entryFactory;
    final DefaultEvictionListener evictionListener;
    private EvictionManager evictionManager;

    protected DefaultDataContainer(int concurrencyLevel) {
        this.immortalEntries = new ConcurrentHashMap<Object, InternalCacheEntry>(128, 0.75f, concurrencyLevel);
        this.mortalEntries = new ConcurrentHashMap<Object, InternalCacheEntry>(64, 0.75f, concurrencyLevel);
        this.entryFactory = new InternalEntryFactory();
        this.evictionListener = null;
    }

    protected DefaultDataContainer(int concurrencyLevel, int maxEntries, EvictionStrategy strategy, EvictionThreadPolicy policy) {
        BoundedConcurrentHashMap.Eviction eviction;
        switch (policy) {
            case PIGGYBACK: 
            case DEFAULT: {
                this.evictionListener = new DefaultEvictionListener();
                break;
            }
            default: {
                throw new IllegalArgumentException("No such eviction thread policy " + (Object)((Object)strategy));
            }
        }
        switch (strategy) {
            case FIFO: 
            case UNORDERED: 
            case LRU: {
                eviction = BoundedConcurrentHashMap.Eviction.LRU;
                break;
            }
            case LIRS: {
                eviction = BoundedConcurrentHashMap.Eviction.LIRS;
                break;
            }
            default: {
                throw new IllegalArgumentException("No such eviction strategy " + (Object)((Object)strategy));
            }
        }
        this.immortalEntries = new BoundedConcurrentHashMap<Object, InternalCacheEntry>(maxEntries, concurrencyLevel, eviction, this.evictionListener);
        this.mortalEntries = new ConcurrentHashMap<Object, InternalCacheEntry>(64, 0.75f, concurrencyLevel);
        this.entryFactory = new InternalEntryFactory();
    }

    @Inject
    public void initialize(EvictionManager evictionManager) {
        this.evictionManager = evictionManager;
    }

    public static DataContainer boundedDataContainer(int concurrencyLevel, int maxEntries, EvictionStrategy strategy, EvictionThreadPolicy policy) {
        return new DefaultDataContainer(concurrencyLevel, maxEntries, strategy, policy){

            @Override
            public int size() {
                return this.immortalEntries.size() + this.mortalEntries.size();
            }
        };
    }

    public static DataContainer unBoundedDataContainer(int concurrencyLevel) {
        return new DefaultDataContainer(concurrencyLevel);
    }

    @Override
    public InternalCacheEntry peek(Object key) {
        InternalCacheEntry e = (InternalCacheEntry)this.immortalEntries.get(key);
        if (e == null) {
            e = (InternalCacheEntry)this.mortalEntries.get(key);
        }
        return e;
    }

    @Override
    public InternalCacheEntry get(Object k) {
        InternalCacheEntry e = this.peek(k);
        if (e != null) {
            if (e.isExpired()) {
                if (this.mortalEntries.remove(k) != null) {
                    this.numEntries.getAndDecrement();
                }
                e = null;
            } else {
                e.touch();
            }
        }
        return e;
    }

    protected void successfulPut(InternalCacheEntry ice, boolean newEntry) {
    }

    @Override
    public void put(Object k, Object v, long lifespan, long maxIdle) {
        InternalCacheEntry e = (InternalCacheEntry)this.immortalEntries.get(k);
        if (e != null) {
            e.setValue(v);
            e = this.entryFactory.update(e, lifespan, maxIdle);
            if (e.canExpire()) {
                this.immortalEntries.remove(k);
                this.mortalEntries.put(k, e);
            }
            this.successfulPut(e, false);
        } else {
            e = (InternalCacheEntry)this.mortalEntries.get(k);
            if (e != null) {
                e.setValue(v);
                InternalCacheEntry original = e;
                e = this.entryFactory.update(e, lifespan, maxIdle);
                if (!e.canExpire()) {
                    this.mortalEntries.remove(k);
                    this.immortalEntries.put(k, e);
                } else if (e != original) {
                    this.mortalEntries.put(k, e);
                } else {
                    e.reincarnate();
                }
                this.successfulPut(e, false);
            } else {
                this.numEntries.getAndIncrement();
                e = this.entryFactory.createNewEntry(k, v, lifespan, maxIdle);
                if (e.canExpire()) {
                    this.mortalEntries.put(k, e);
                } else {
                    this.immortalEntries.put(k, e);
                }
                this.successfulPut(e, true);
            }
        }
    }

    @Override
    public boolean containsKey(Object k) {
        InternalCacheEntry ice = this.peek(k);
        if (ice != null && ice.isExpired()) {
            if (this.mortalEntries.remove(k) != null) {
                this.numEntries.getAndDecrement();
            }
            ice = null;
        }
        return ice != null;
    }

    @Override
    public InternalCacheEntry remove(Object k) {
        InternalCacheEntry e = (InternalCacheEntry)this.immortalEntries.remove(k);
        if (e == null) {
            e = (InternalCacheEntry)this.mortalEntries.remove(k);
        }
        if (e != null) {
            this.numEntries.getAndDecrement();
        }
        return e == null || e.isExpired() ? null : e;
    }

    @Override
    public int size() {
        return this.numEntries.get();
    }

    @Override
    public void clear() {
        this.immortalEntries.clear();
        this.mortalEntries.clear();
        this.numEntries.set(0);
    }

    @Override
    public Set<Object> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<Object> values() {
        return new Values();
    }

    @Override
    public Set<InternalCacheEntry> entrySet() {
        return new EntrySet();
    }

    @Override
    public void purgeExpired() {
        Iterator entries = this.mortalEntries.values().iterator();
        while (entries.hasNext()) {
            InternalCacheEntry e = (InternalCacheEntry)entries.next();
            if (!e.isExpired()) continue;
            entries.remove();
            this.numEntries.getAndDecrement();
        }
    }

    @Override
    public Iterator<InternalCacheEntry> iterator() {
        return new EntryIterator(this.immortalEntries.values().iterator(), this.mortalEntries.values().iterator());
    }

    private class ValueIterator
    extends MortalInmortalIterator
    implements Iterator<Object> {
        private ValueIterator(Iterator<InternalCacheEntry> immortalIterator, Iterator<InternalCacheEntry> mortalIterator) {
            super(immortalIterator, mortalIterator);
        }

        @Override
        public Object next() {
            return ((InternalCacheEntry)this.currentIterator.next()).getValue();
        }
    }

    private class Values
    extends AbstractCollection<Object> {
        private Values() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new ValueIterator(DefaultDataContainer.this.immortalEntries.values().iterator(), DefaultDataContainer.this.mortalEntries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.immortalEntries.size() + DefaultDataContainer.this.mortalEntries.size();
        }
    }

    private class ImmutableEntryIterator
    extends MortalInmortalIterator
    implements Iterator<InternalCacheEntry> {
        private ImmutableEntryIterator(Iterator<InternalCacheEntry> immortalIterator, Iterator<InternalCacheEntry> mortalIterator) {
            super(immortalIterator, mortalIterator);
        }

        @Override
        public InternalCacheEntry next() {
            return Immutables.immutableInternalCacheEntry((InternalCacheEntry)this.currentIterator.next());
        }
    }

    private class EntryIterator
    extends MortalInmortalIterator
    implements Iterator<InternalCacheEntry> {
        private EntryIterator(Iterator<InternalCacheEntry> immortalIterator, Iterator<InternalCacheEntry> mortalIterator) {
            super(immortalIterator, mortalIterator);
        }

        @Override
        public InternalCacheEntry next() {
            return (InternalCacheEntry)this.currentIterator.next();
        }
    }

    private static class MortalInmortalIterator {
        Iterator<Iterator<InternalCacheEntry>> metaIterator;
        Iterator<InternalCacheEntry> currentIterator;

        private MortalInmortalIterator(Iterator<InternalCacheEntry> immortalIterator, Iterator<InternalCacheEntry> mortalIterator) {
            this.metaIterator = Arrays.asList(immortalIterator, mortalIterator).iterator();
            if (this.metaIterator.hasNext()) {
                this.currentIterator = this.metaIterator.next();
            }
        }

        public boolean hasNext() {
            boolean hasNext = this.currentIterator.hasNext();
            while (!hasNext && this.metaIterator.hasNext()) {
                this.currentIterator = this.metaIterator.next();
                hasNext = this.currentIterator.hasNext();
            }
            return hasNext;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntrySet
    extends AbstractSet<InternalCacheEntry> {
        private EntrySet() {
        }

        @Override
        public Iterator<InternalCacheEntry> iterator() {
            return new ImmutableEntryIterator(DefaultDataContainer.this.immortalEntries.values().iterator(), DefaultDataContainer.this.mortalEntries.values().iterator());
        }

        @Override
        public int size() {
            return DefaultDataContainer.this.immortalEntries.size() + DefaultDataContainer.this.mortalEntries.size();
        }
    }

    private static class KeyIterator
    implements Iterator<Object> {
        Iterator<Iterator<Object>> metaIterator;
        Iterator<Object> currentIterator;

        private KeyIterator(Iterator<Object> immortalIterator, Iterator<Object> mortalIterator) {
            this.metaIterator = Arrays.asList(immortalIterator, mortalIterator).iterator();
            if (this.metaIterator.hasNext()) {
                this.currentIterator = this.metaIterator.next();
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.currentIterator.hasNext();
            while (!hasNext && this.metaIterator.hasNext()) {
                this.currentIterator = this.metaIterator.next();
                hasNext = this.currentIterator.hasNext();
            }
            return hasNext;
        }

        @Override
        public Object next() {
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<Object> {
        final Set<Object> immortalKeys;
        final Set<Object> mortalKeys;

        public KeySet() {
            this.immortalKeys = DefaultDataContainer.this.immortalEntries.keySet();
            this.mortalKeys = DefaultDataContainer.this.mortalEntries.keySet();
        }

        @Override
        public Iterator<Object> iterator() {
            return new KeyIterator(this.immortalKeys.iterator(), this.mortalKeys.iterator());
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.immortalKeys.contains(o) || this.mortalKeys.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.immortalKeys.size() + this.mortalKeys.size();
        }
    }

    private class DefaultEvictionListener
    implements BoundedConcurrentHashMap.EvictionListener<Object, InternalCacheEntry> {
        private DefaultEvictionListener() {
        }

        @Override
        public void preEvict(Object key) {
            DefaultDataContainer.this.evictionManager.preEvict(key);
        }

        @Override
        public void postEvict(Object key, InternalCacheEntry value) {
            DefaultDataContainer.this.evictionManager.postEvict(key, value);
        }
    }
}

