/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import org.infinispan.commands.tx.TransactionBoundaryCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.RemoteTransaction;
import org.infinispan.transaction.xa.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractTransactionBoundaryCommand
implements TransactionBoundaryCommand {
    private static final Log log = LogFactory.getLog(AbstractTransactionBoundaryCommand.class);
    private static boolean trace = log.isTraceEnabled();
    protected GlobalTransaction globalTx;
    protected String cacheName;
    protected InterceptorChain invoker;
    protected InvocationContextContainer icc;
    protected TransactionTable txTable;

    public void init(InterceptorChain chain, InvocationContextContainer icc, TransactionTable txTable) {
        this.invoker = chain;
        this.icc = icc;
        this.txTable = txTable;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.globalTx;
    }

    @Override
    public void markTransactionAsRemote(boolean isRemote) {
        this.globalTx.setRemote(isRemote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (ctx != null) {
            throw new IllegalStateException("Expected null context!");
        }
        this.markGtxAsRemote();
        RemoteTransaction transaction = this.txTable.getRemoteTransaction(this.globalTx);
        if (transaction == null) {
            if (trace) {
                log.info("Not found RemoteTransaction for tx id: " + this.globalTx);
            }
            return null;
        }
        RemoteTxInvocationContext ctxt = this.icc.createRemoteTxInvocationContext();
        ctxt.setRemoteTransaction(transaction);
        try {
            if (trace) {
                log.trace("About to execute tx command :" + this);
            }
            Object object = this.invoker.invoke(ctxt, this);
            return object;
        }
        finally {
            this.txTable.removeRemoteTransaction(this.globalTx);
        }
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.globalTx, this.cacheName};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.globalTx = (GlobalTransaction)args[0];
        this.cacheName = (String)args[1];
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTransactionBoundaryCommand that = (AbstractTransactionBoundaryCommand)o;
        return this.globalTx.equals(that.globalTx);
    }

    public int hashCode() {
        return this.globalTx.hashCode();
    }

    public String toString() {
        return ", gtx=" + this.globalTx + ", cacheName='" + this.cacheName + '\'' + '}';
    }

    private void markGtxAsRemote() {
        this.globalTx.setRemote(true);
    }
}

