/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.marshall.Marshallable;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransactionFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Marshallable(externalizer=Externalizer.class, id=43)
public class DldGlobalTransaction
extends GlobalTransaction {
    private static Log log = LogFactory.getLog(DldGlobalTransaction.class);
    public static final boolean trace = log.isTraceEnabled();
    private volatile long coinToss;
    private volatile boolean isMarkedForRollback;
    private volatile transient Object lockLocalLockIntention;
    protected volatile Set<Object> remoteLockIntention = Collections.EMPTY_SET;

    public DldGlobalTransaction() {
    }

    DldGlobalTransaction(Address addr, boolean remote) {
        super(addr, remote);
    }

    public void setCoinToss(long coinToss) {
        this.coinToss = coinToss;
    }

    public long getCoinToss() {
        return this.coinToss;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DldGlobalTransaction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DldGlobalTransaction that = (DldGlobalTransaction)o;
        return this.coinToss == that.coinToss;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.coinToss ^ this.coinToss >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "DldGlobalTransaction{coinToss=" + this.coinToss + ", isMarkedForRollback=" + this.isMarkedForRollback + ", lockIntention=" + this.lockLocalLockIntention + ", affectedKeys=" + this.remoteLockIntention + "} " + super.toString();
    }

    public synchronized boolean isMarkedForRollback() {
        return this.isMarkedForRollback;
    }

    public synchronized void setMarkedForRollback(boolean markedForRollback) {
        this.isMarkedForRollback = markedForRollback;
    }

    public Object getLockIntention() {
        return this.lockLocalLockIntention;
    }

    public void setLockLocalLockIntention(Object lockIntention) {
        this.lockLocalLockIntention = lockIntention;
    }

    public boolean wouldLose(DldGlobalTransaction other) {
        return this.coinToss < other.coinToss;
    }

    public boolean isAcquiringRemoteLock(Object key, Address address) {
        boolean contains = this.remoteLockIntention.contains(key);
        if (trace) {
            log.trace("Intention check: does " + this.remoteLockIntention + " contain " + key + "? " + contains);
        }
        return contains;
    }

    public void setRemoteLockIntention(Set<Object> remoteLockIntention) {
        if (trace) {
            log.trace("Setting the affected keys set to: " + remoteLockIntention);
        }
        this.remoteLockIntention = remoteLockIntention;
    }

    public Set<Object> getRemoteLockIntention() {
        return this.remoteLockIntention;
    }

    public static class Externalizer
    extends GlobalTransaction.Externalizer {
        public Externalizer() {
            this.gtxFactory = new GlobalTransactionFactory(true);
        }

        @Override
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            super.writeObject(output, subject);
            DldGlobalTransaction ddGt = (DldGlobalTransaction)subject;
            output.writeLong(ddGt.getCoinToss());
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            DldGlobalTransaction ddGt = (DldGlobalTransaction)super.readObject(input);
            ddGt.setCoinToss(input.readLong());
            return ddGt;
        }
    }
}

