/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Collections;
import javax.transaction.TransactionManager;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.util.concurrent.locks.LockManager;

public class DeadlockDetectingInterceptor
extends CommandInterceptor {
    private LockManager lockManager;
    private TransactionManager txManager;

    @Inject
    public void init(LockManager lockManager, TransactionManager txManager) {
        this.lockManager = lockManager;
        this.txManager = txManager;
    }

    @Start
    public void start() {
        if (!this.configuration.isEnableDeadlockDetection()) {
            throw new IllegalStateException("This interceptor should not be present in the chain as deadlock detection is not used!");
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleDataCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleDataCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleDataCommand(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        DldGlobalTransaction globalTransaction = (DldGlobalTransaction)ctx.getGlobalTransaction();
        if (ctx.isOriginLocal()) {
            globalTransaction.setRemoteLockIntention(command.getKeys());
        }
        return this.handleDataCommand(ctx, command);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        DldGlobalTransaction globalTransaction = (DldGlobalTransaction)ctx.getGlobalTransaction();
        if (ctx.isOriginLocal()) {
            globalTransaction.setRemoteLockIntention(command.getAffectedKeys());
        }
        Object result = this.invokeNextInterceptor(ctx, command);
        if (ctx.isOriginLocal()) {
            globalTransaction.setRemoteLockIntention(Collections.EMPTY_SET);
        }
        return result;
    }

    private Object handleDataCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }
}

