/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class EvictionManagerImpl
implements EvictionManager {
    private static final Log log = LogFactory.getLog(EvictionManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    ScheduledFuture<?> evictionTask;
    private ScheduledExecutorService executor;
    private Configuration configuration;
    private CacheLoaderManager cacheLoaderManager;
    private DataContainer dataContainer;
    private CacheStore cacheStore;
    private CacheNotifier cacheNotifier;
    private LockManager lockManager;
    private PassivationManager passivator;
    private InvocationContextContainer ctxContainer;
    private boolean enabled;
    volatile CountDownLatch startLatch = new CountDownLatch(1);

    @Inject
    public void initialize(@ComponentName(value="org.infinispan.executors.eviction") ScheduledExecutorService executor, Configuration configuration, DataContainer dataContainer, CacheLoaderManager cacheLoaderManager, CacheNotifier cacheNotifier, LockManager lockManager, PassivationManager passivator, InvocationContextContainer ctxContainer) {
        this.executor = executor;
        this.configuration = configuration;
        this.dataContainer = dataContainer;
        this.cacheLoaderManager = cacheLoaderManager;
        this.cacheNotifier = cacheNotifier;
        this.lockManager = lockManager;
        this.passivator = passivator;
        this.ctxContainer = ctxContainer;
    }

    @Start(priority=55)
    public void start() {
        boolean bl = this.enabled = this.configuration.getEvictionStrategy() != EvictionStrategy.NONE;
        if (this.enabled) {
            if (this.cacheLoaderManager != null && this.cacheLoaderManager.isEnabled()) {
                this.cacheStore = this.cacheLoaderManager.getCacheStore();
            }
            if (this.configuration.getEvictionWakeUpInterval() <= 0L) {
                log.info("wakeUpInterval is <= 0, not starting eviction thread");
            } else {
                this.evictionTask = this.executor.scheduleWithFixedDelay(new ScheduledTask(), this.configuration.getEvictionWakeUpInterval(), this.configuration.getEvictionWakeUpInterval(), TimeUnit.MILLISECONDS);
            }
        }
        this.startLatch.countDown();
    }

    @Override
    public void processEviction() {
        try {
            this.startLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.enabled) {
            return;
        }
        long start = 0L;
        try {
            if (trace) {
                log.trace("Purging data container of expired entries");
                start = System.currentTimeMillis();
            }
            this.dataContainer.purgeExpired();
            if (trace) {
                log.trace((Object)"Purging data container completed in {0}", Util.prettyPrintTime(System.currentTimeMillis() - start));
            }
        }
        catch (Exception e) {
            log.warn((Object)"Caught exception purging data container!", e);
        }
        if (this.cacheStore != null) {
            try {
                if (trace) {
                    log.trace("Purging cache store of expired entries");
                    start = System.currentTimeMillis();
                }
                this.cacheStore.purgeExpired();
                if (trace) {
                    log.trace((Object)"Purging cache store completed in {0}", Util.prettyPrintTime(System.currentTimeMillis() - start));
                }
            }
            catch (Exception e) {
                log.warn((Object)"Caught exception purging cache store!", e);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Stop(priority=5)
    public void stop() {
        this.startLatch = new CountDownLatch(1);
        if (this.evictionTask != null) {
            this.evictionTask.cancel(true);
        }
    }

    @Override
    public void preEvict(Object key) {
        try {
            this.acquireLock(this.getInvocationContext(), key);
        }
        catch (Exception e) {
            log.warn((Object)"Could not acquire lock for eviction of {0}", key, e);
        }
        this.cacheNotifier.notifyCacheEntryEvicted(key, true, null);
    }

    @Override
    public void postEvict(Object key, InternalCacheEntry value) {
        try {
            this.passivator.passivate(key, value, null);
        }
        catch (CacheLoaderException e) {
            log.warn((Object)"Unable to passivate entry under {0}", key, e);
        }
        this.cacheNotifier.notifyCacheEntryEvicted(key, false, null);
        this.releaseLock(key);
    }

    private InvocationContext getInvocationContext() {
        return this.ctxContainer.getInvocationContext();
    }

    private boolean acquireLock(InvocationContext ctx, Object key) throws InterruptedException, TimeoutException {
        boolean shouldSkipLocking = ctx.hasFlag(Flag.SKIP_LOCKING);
        if (!ctx.hasLockedKey(key) && !shouldSkipLocking) {
            if (this.lockManager.lockAndRecord(key, ctx)) {
                return true;
            }
            Object owner = this.lockManager.getOwner(key);
            if (key instanceof MarshalledValue) {
                key = ((MarshalledValue)key).get();
            }
            throw new TimeoutException("Unable to acquire lock after [" + Util.prettyPrintTime(this.getLockAcquisitionTimeout(ctx)) + "] on key [" + key + "] for requestor [" + ctx.getLockOwner() + "]! Lock held by [" + owner + "]");
        }
        if (trace) {
            if (shouldSkipLocking) {
                log.trace("SKIP_LOCKING flag used!");
            } else {
                log.trace("Already own lock for entry");
            }
        }
        return false;
    }

    public final void releaseLock(Object key) {
        this.lockManager.unlock(key);
    }

    private long getLockAcquisitionTimeout(InvocationContext ctx) {
        return ctx.hasFlag(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT) ? 0L : this.configuration.getLockAcquisitionTimeout();
    }

    class ScheduledTask
    implements Runnable {
        ScheduledTask() {
        }

        @Override
        public void run() {
            EvictionManagerImpl.this.processEviction();
        }
    }
}

