/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.config.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReplicationQueue {
    private static final Log log = LogFactory.getLog(ReplicationQueue.class);
    private long maxElements = 500L;
    private final BlockingQueue<ReplicableCommand> elements = new LinkedBlockingQueue<ReplicableCommand>();
    private ScheduledExecutorService scheduledExecutor = null;
    private RpcManager rpcManager;
    private Configuration configuration;
    private boolean enabled;
    private CommandsFactory commandsFactory;

    public boolean isEnabled() {
        return this.enabled;
    }

    @Inject
    private void injectDependencies(@ComponentName(value="org.infinispan.executors.replicationQueue") ScheduledExecutorService executor, RpcManager rpcManager, Configuration configuration, CommandsFactory commandsFactory) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.commandsFactory = commandsFactory;
        this.scheduledExecutor = executor;
    }

    @Start
    public void start() {
        long interval = this.configuration.getReplQueueInterval();
        log.trace((Object)"Starting replication queue, with interval {0} and maxElements {1}", interval, this.maxElements);
        this.maxElements = this.configuration.getReplQueueMaxElements();
        this.enabled = this.configuration.isUseReplQueue();
        if (this.enabled && interval > 0L) {
            this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ReplicationQueue.this.flush();
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
        }
    }

    @Stop(priority=9)
    public void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
        this.scheduledExecutor = null;
    }

    public void add(ReplicableCommand job) {
        if (job == null) {
            throw new NullPointerException("job is null");
        }
        try {
            this.elements.put(job);
            if ((long)this.elements.size() >= this.maxElements) {
                this.flush();
            }
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
    }

    public void flush() {
        int toReplicateSize;
        LinkedList<ReplicableCommand> toReplicate = new LinkedList<ReplicableCommand>();
        this.elements.drainTo(toReplicate);
        if (log.isTraceEnabled()) {
            log.trace((Object)"flush(): flushing repl queue (num elements={0})", toReplicate.size());
        }
        if ((toReplicateSize = toReplicate.size()) > 0) {
            try {
                log.trace((Object)"Flushing {0} elements", toReplicateSize);
                MultipleRpcCommand multipleRpcCommand = this.commandsFactory.buildReplicateCommand(toReplicate);
                this.rpcManager.invokeRemotely(null, (ReplicableCommand)multipleRpcCommand, ResponseMode.getAsyncResponseMode(this.configuration), this.configuration.getSyncReplTimeout());
            }
            catch (Throwable t) {
                log.error((Object)("failed replicating " + toReplicate.size() + " elements in replication queue"), t);
            }
        }
    }

    public int getElementsCount() {
        return this.elements.size();
    }

    public void reset() {
        this.elements.clear();
    }
}

