/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import org.infinispan.config.AbstractConfigurationBeanVisitor;
import org.infinispan.config.CacheLoaderManagerConfig;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.loaders.decorators.SingletonStoreConfig;

public class ConfigurationValidatingVisitor
extends AbstractConfigurationBeanVisitor {
    private GlobalConfiguration.TransportType tt = null;
    private CacheLoaderManagerConfig clmc = null;
    private Configuration.EvictionType eviction = null;

    @Override
    public void visitSingletonStoreConfig(SingletonStoreConfig ssc) {
        if (this.tt == null && ssc.isSingletonStoreEnabled().booleanValue()) {
            throw new ConfigurationException("Singleton store configured without transport being configured");
        }
    }

    @Override
    public void visitTransportType(GlobalConfiguration.TransportType tt) {
        this.tt = tt;
    }

    @Override
    public void visitConfiguration(Configuration bean) {
        this.checkEagerLockingAndDld(bean);
    }

    private void checkEagerLockingAndDld(Configuration bean) {
        boolean isEagerLocking = bean.isUseEagerLocking();
        ConfigurationValidatingVisitor.checkEagerLockingAndDld(bean, isEagerLocking);
    }

    public static void checkEagerLockingAndDld(Configuration bean, boolean eagerLocking) {
        boolean isDealLockDetection = bean.isEnableDeadlockDetection();
        if (isDealLockDetection && eagerLocking) {
            throw new ConfigurationException("Deadlock detection cannot be used with eager locking until ISPN-596 is fixed. See https://jira.jboss.org/browse/ISPN-596");
        }
    }
}

