/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.CacheException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReflectionUtil {
    private static final Log log = LogFactory.getLog(ReflectionUtil.class);

    public static List<Method> getAllMethods(Class c, Class<? extends Annotation> annotationType) {
        LinkedList<Method> annotated = new LinkedList<Method>();
        ReflectionUtil.inspectRecursively(c, annotated, annotationType);
        return annotated;
    }

    private static void getAnnotatedFieldHelper(List<Field> list, Class<?> c, Class<? extends Annotation> annotationType) {
        Field[] declaredFields;
        for (Field field : declaredFields = c.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationType)) continue;
            list.add(field);
        }
    }

    public static List<Field> getAnnotatedFields(Class<?> c, Class<? extends Annotation> annotationType) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (!c.equals(Object.class)) {
            ReflectionUtil.getAnnotatedFieldHelper(fields, c, annotationType);
            c = c.getSuperclass();
        }
        return fields;
    }

    private static void getFieldsHelper(List<Field> list, Class<?> c, Class<?> type) {
        Field[] declaredFields;
        for (Field field : declaredFields = c.getDeclaredFields()) {
            if (!type.isAssignableFrom(field.getType())) continue;
            list.add(field);
        }
    }

    public static List<Field> getFields(Class<?> c, Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (!c.equals(Object.class)) {
            ReflectionUtil.getFieldsHelper(fields, c, type);
            c = c.getSuperclass();
        }
        return fields;
    }

    private static void inspectRecursively(Class c, List<Method> s, Class<? extends Annotation> annotationType) {
        for (Method method : c.getDeclaredMethods()) {
            if (!ReflectionUtil.notFound(method, s) || !method.isAnnotationPresent(annotationType)) continue;
            s.add(method);
        }
        if (!c.equals(Object.class) && !c.isInterface()) {
            ReflectionUtil.inspectRecursively(c.getSuperclass(), s, annotationType);
            for (GenericDeclaration genericDeclaration : c.getInterfaces()) {
                ReflectionUtil.inspectRecursively((Class)genericDeclaration, s, annotationType);
            }
        }
    }

    private static boolean notFound(Method m, Collection<Method> s) {
        for (Method found : s) {
            if (!m.getName().equals(found.getName()) || !Arrays.equals(m.getParameterTypes(), found.getParameterTypes())) continue;
            return false;
        }
        return true;
    }

    public static void setValue(Object instance, String fieldName, Object value) {
        try {
            Field f = ReflectionUtil.findFieldRecursively(instance.getClass(), fieldName);
            if (f == null) {
                throw new NoSuchMethodException("Cannot find field " + fieldName + " on " + instance.getClass() + " or superclasses");
            }
            f.setAccessible(true);
            f.set(instance, value);
        }
        catch (Exception e) {
            log.error((Object)"Unable to set value!", e);
        }
    }

    private static Field findFieldRecursively(Class c, String fieldName) {
        Field f;
        block2: {
            f = null;
            try {
                f = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                if (c.equals(Object.class)) break block2;
                f = ReflectionUtil.findFieldRecursively(c.getSuperclass(), fieldName);
            }
        }
        return f;
    }

    public static void invokeAccessibly(Object instance, Method method, Object[] parameters) {
        try {
            method.setAccessible(true);
            method.invoke(instance, parameters);
        }
        catch (Exception e) {
            throw new CacheException("Unable to invoke method " + method + " on object " + (parameters != null ? " with parameters " + Arrays.asList(parameters) : ""), e);
        }
    }

    public static Method findGetterForField(Class<?> c, String fieldName) throws NoSuchMethodException {
        for (Method m : c.getDeclaredMethods()) {
            String name = m.getName();
            String s = null;
            if (name.startsWith("get")) {
                s = name.substring(3);
            } else if (name.startsWith("is")) {
                s = name.substring(2);
            }
            if (s == null || !s.equalsIgnoreCase(fieldName)) continue;
            return m;
        }
        throw new NoSuchMethodException("Cannot find getter method  for field " + fieldName + " in " + c + " or superclasses");
    }

    public static Object getValue(Object instance, String fieldName) {
        Field f = ReflectionUtil.findFieldRecursively(instance.getClass(), fieldName);
        if (f == null) {
            throw new CacheException("Could not find field named: " + fieldName + " on instance :" + instance);
        }
        try {
            f.setAccessible(true);
            return f.get(instance);
        }
        catch (IllegalAccessException iae) {
            throw new CacheException("Cannot access field " + f, iae);
        }
    }

    public static <T extends Annotation> T getAnnotation(Class clazz, Class<T> ann) {
        T a;
        while ((a = clazz.getAnnotation(ann)) == null) {
            Class superclass;
            if (!clazz.isInterface()) {
                Class<?>[] interfaces;
                for (Class<?> inter : interfaces = clazz.getInterfaces()) {
                    a = ReflectionUtil.getAnnotation(inter, ann);
                    if (a == null) continue;
                    return a;
                }
            }
            if ((superclass = clazz.getSuperclass()) == null) {
                return null;
            }
            clazz = superclass;
        }
        return a;
    }

    public static boolean isAnnotationPresent(Class clazz, Class<? extends Annotation> annotation) {
        return ReflectionUtil.getAnnotation(clazz, annotation) != null;
    }
}

