/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.jboss;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import org.infinispan.CacheException;
import org.infinispan.commands.RemoteCommandsFactory;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.marshall.AbstractMarshaller;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.jboss.ConstantObjectTable;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ContextClassResolver;
import org.jboss.marshalling.Creator;
import org.jboss.marshalling.ExceptionListener;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.TraceInformation;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SunReflectiveCreator;

public class JBossMarshaller
extends AbstractMarshaller {
    private static final Log log = LogFactory.getLog(JBossMarshaller.class);
    private static final String DEFAULT_MARSHALLER_FACTORY = "org.jboss.marshalling.river.RiverMarshallerFactory";
    private ClassLoader defaultCl;
    private MarshallingConfiguration configuration;
    private MarshallerFactory factory;
    private ConstantObjectTable objectTable;
    private ThreadLocal<org.jboss.marshalling.Marshaller> marshallerTL = new ThreadLocal<org.jboss.marshalling.Marshaller>(){

        @Override
        protected org.jboss.marshalling.Marshaller initialValue() {
            try {
                return JBossMarshaller.this.factory.createMarshaller(JBossMarshaller.this.configuration);
            }
            catch (IOException e) {
                throw new CacheException(e);
            }
        }
    };
    private ThreadLocal<Unmarshaller> unmarshallerTL = new ThreadLocal<Unmarshaller>(){

        @Override
        protected Unmarshaller initialValue() {
            try {
                return JBossMarshaller.this.factory.createUnmarshaller(JBossMarshaller.this.configuration);
            }
            catch (IOException e) {
                throw new CacheException(e);
            }
        }
    };

    public void start(ClassLoader defaultCl, RemoteCommandsFactory cmdFactory, Marshaller ispnMarshaller) {
        if (log.isDebugEnabled()) {
            log.debug("Using JBoss Marshalling");
        }
        this.defaultCl = defaultCl;
        try {
            this.factory = (MarshallerFactory)Util.getInstance(DEFAULT_MARSHALLER_FACTORY);
        }
        catch (Exception e) {
            throw new CacheException("Unable to load JBoss Marshalling marshaller factory org.jboss.marshalling.river.RiverMarshallerFactory", e);
        }
        this.objectTable = this.createCustomObjectTable(cmdFactory, ispnMarshaller);
        this.configuration = new MarshallingConfiguration();
        this.configuration.setCreator((Creator)new SunReflectiveCreator());
        this.configuration.setObjectTable((ObjectTable)this.objectTable);
        this.configuration.setExceptionListener((ExceptionListener)new DebuggingExceptionListener());
        this.configuration.setClassResolver((ClassResolver)new ContextClassResolver());
        this.configuration.setVersion(2);
    }

    public void stop() {
        this.defaultCl = null;
        if (this.objectTable != null) {
            this.objectTable.stop();
        }
    }

    @Override
    public byte[] objectToByteBuffer(Object obj) throws IOException {
        ByteBuffer b = this.objectToBuffer(obj);
        byte[] bytes = new byte[b.getLength()];
        System.arraycopy(b.getBuf(), b.getOffset(), bytes, 0, b.getLength());
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer objectToBuffer(Object o) throws IOException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(128);
        ObjectOutput marshaller = this.startObjectOutput(baos, false);
        try {
            this.objectToObjectStream(o, marshaller);
        }
        finally {
            this.finishObjectOutput(marshaller);
        }
        return new ByteBuffer(baos.getRawBuffer(), 0, baos.size());
    }

    @Override
    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant) throws IOException {
        org.jboss.marshalling.Marshaller marshaller = isReentrant ? this.factory.createMarshaller(this.configuration) : this.marshallerTL.get();
        marshaller.start(Marshalling.createByteOutput((OutputStream)os));
        return marshaller;
    }

    @Override
    public void finishObjectOutput(ObjectOutput oo) {
        try {
            ((org.jboss.marshalling.Marshaller)oo).finish();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        ClassLoader toUse = this.defaultCl;
        Thread current = Thread.currentThread();
        ClassLoader old = current.getContextClassLoader();
        if (old != null) {
            toUse = old;
        }
        try {
            current.setContextClassLoader(toUse);
            out.writeObject(obj);
        }
        finally {
            current.setContextClassLoader(old);
        }
    }

    @Override
    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        return this.objectFromByteBuffer(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(buf, offset, length);
        ObjectInput unmarshaller = this.startObjectInput(is, false);
        Object o = null;
        try {
            o = this.objectFromObjectStream(unmarshaller);
        }
        finally {
            this.finishObjectInput(unmarshaller);
        }
        return o;
    }

    @Override
    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        Unmarshaller unmarshaller = isReentrant ? this.factory.createUnmarshaller(this.configuration) : this.unmarshallerTL.get();
        unmarshaller.start(Marshalling.createByteInput((InputStream)is));
        return unmarshaller;
    }

    @Override
    public void finishObjectInput(ObjectInput oi) {
        try {
            if (oi != null) {
                ((Unmarshaller)oi).finish();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException {
        return in.readObject();
    }

    private ConstantObjectTable createCustomObjectTable(RemoteCommandsFactory cmdFactory, Marshaller ispnMarshaller) {
        ConstantObjectTable objectTable = new ConstantObjectTable();
        objectTable.start(cmdFactory, ispnMarshaller);
        return objectTable;
    }

    private static class DebuggingExceptionListener
    implements ExceptionListener {
        private static final URL[] EMPTY_URLS = new URL[0];
        private static final Class[] EMPTY_CLASSES = new Class[0];
        private static final Object[] EMPTY_OBJECTS = new Object[0];

        private DebuggingExceptionListener() {
        }

        public void handleMarshallingException(Throwable problem, Object subject) {
            if (log.isDebugEnabled()) {
                TraceInformation.addUserInformation((Throwable)problem, (Serializable)((Object)("toString = " + subject.toString())));
            }
        }

        public void handleUnmarshallingException(Throwable problem, Class<?> subjectClass) {
            if (log.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder();
                ClassLoader cl = subjectClass.getClassLoader();
                builder.append("classloader hierarchy:");
                for (ClassLoader parent = cl; parent != null; parent = parent.getParent()) {
                    if (parent.equals(cl)) {
                        builder.append("\n\t\t-> type classloader = ").append(parent);
                    } else {
                        builder.append("\n\t\t-> parent classloader = ").append(parent);
                    }
                    URL[] urls = DebuggingExceptionListener.getClassLoaderURLs(parent);
                    if (urls == null) continue;
                    for (URL u : urls) {
                        builder.append("\n\t\t->...").append(u);
                    }
                }
                TraceInformation.addUserInformation((Throwable)problem, (Serializable)((Object)builder.toString()));
            }
        }

        public void handleUnmarshallingException(Throwable problem) {
        }

        private static URL[] getClassLoaderURLs(ClassLoader cl) {
            URL[] urls = EMPTY_URLS;
            try {
                Class<?> returnType = urls.getClass();
                Class[] parameterTypes = EMPTY_CLASSES;
                Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
                if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                    Object[] args = EMPTY_OBJECTS;
                    urls = (URL[])getURLs.invoke((Object)cl, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return urls;
        }
    }
}

