/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.AbstractCacheStore;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.LockSupportCacheStoreConfig;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.concurrent.locks.StripedLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class LockSupportCacheStore
extends AbstractCacheStore {
    private static final Log log = LogFactory.getLog(LockSupportCacheStore.class);
    private static final boolean trace = log.isTraceEnabled();
    private StripedLock locks;
    private long globalLockTimeoutMillis;
    private LockSupportCacheStoreConfig config;

    @Override
    public void init(CacheLoaderConfig config, Cache<?, ?> cache, Marshaller m) throws CacheLoaderException {
        super.init(config, cache, m);
        this.config = (LockSupportCacheStoreConfig)config;
    }

    @Override
    public void start() throws CacheLoaderException {
        super.start();
        if (this.config == null) {
            throw new CacheLoaderException("Null config. Possible reason is not calling super.init(...)");
        }
        this.locks = new StripedLock(this.config.getLockConcurrencyLevel());
        this.globalLockTimeoutMillis = this.config.getLockAcquistionTimeout();
    }

    protected final void unlock(String key) {
        this.locks.releaseLock(key);
    }

    protected final void lockForWriting(String key) throws CacheLoaderException {
        this.locks.acquireLock(key, true);
    }

    protected final void lockForReading(String key) throws CacheLoaderException {
        this.locks.acquireLock(key, false);
    }

    protected final boolean immediateLockForWriting(String key) throws CacheLoaderException {
        return this.locks.acquireLock(key, true, 0L);
    }

    protected final void acquireGlobalLock(boolean exclusive) throws CacheLoaderException {
        this.locks.aquireGlobalLock(exclusive, this.globalLockTimeoutMillis);
    }

    protected final void releaseGlobalLock(boolean exclusive) {
        this.locks.releaseGlobalLock(exclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final InternalCacheEntry load(Object key) throws CacheLoaderException {
        String lockingKey = this.getLockFromKey(key);
        this.lockForReading(lockingKey);
        try {
            InternalCacheEntry internalCacheEntry = this.loadLockSafe(key, lockingKey);
            return internalCacheEntry;
        }
        finally {
            this.unlock(lockingKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        this.acquireGlobalLock(false);
        try {
            Set<InternalCacheEntry> set = this.loadAllLockSafe();
            return set;
        }
        finally {
            this.releaseGlobalLock(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<InternalCacheEntry> load(int maxEntries) throws CacheLoaderException {
        if (maxEntries < 0) {
            return this.loadAll();
        }
        this.acquireGlobalLock(false);
        try {
            Set<InternalCacheEntry> set = this.loadLockSafe(maxEntries);
            return set;
        }
        finally {
            this.releaseGlobalLock(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        this.acquireGlobalLock(false);
        try {
            Set<Object> set = this.loadAllKeysLockSafe(keysToExclude);
            return set;
        }
        finally {
            this.releaseGlobalLock(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void store(InternalCacheEntry ed) throws CacheLoaderException {
        if (trace) {
            log.trace("store(" + ed + ")");
        }
        if (ed == null) {
            return;
        }
        if (ed.isExpired()) {
            if (this.containsKey(ed.getKey())) {
                if (trace) {
                    log.trace("Entry " + ed + " is expired!  Removing!");
                }
                this.remove(ed.getKey());
            } else if (trace) {
                log.trace("Entry " + ed + " is expired!  Not doing anything.");
            }
            return;
        }
        String keyHashCode = this.getLockFromKey(ed.getKey());
        this.lockForWriting(keyHashCode);
        try {
            this.storeLockSafe(ed, keyHashCode);
        }
        finally {
            this.unlock(keyHashCode);
        }
        if (trace) {
            log.trace("exit store(" + ed + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean remove(Object key) throws CacheLoaderException {
        if (trace) {
            log.trace("remove(" + key + ")");
        }
        String keyHashCodeStr = this.getLockFromKey(key);
        try {
            this.lockForWriting(keyHashCodeStr);
            boolean bl = this.removeLockSafe(key, keyHashCodeStr);
            return bl;
        }
        finally {
            this.unlock(keyHashCodeStr);
            if (trace) {
                log.trace("Exit remove(" + key + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fromStream(ObjectInput objectInput) throws CacheLoaderException {
        try {
            this.acquireGlobalLock(true);
            this.clear();
            this.fromStreamLockSafe(objectInput);
        }
        finally {
            this.releaseGlobalLock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toStream(ObjectOutput objectOutput) throws CacheLoaderException {
        try {
            this.acquireGlobalLock(false);
            this.toStreamLockSafe(objectOutput);
        }
        finally {
            this.releaseGlobalLock(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() throws CacheLoaderException {
        if (trace) {
            log.trace("Clearing store");
        }
        try {
            this.acquireGlobalLock(true);
            this.clearLockSafe();
        }
        finally {
            this.releaseGlobalLock(true);
        }
    }

    public int getTotalLockCount() {
        return this.locks.getTotalLockCount();
    }

    protected abstract void clearLockSafe() throws CacheLoaderException;

    protected abstract Set<InternalCacheEntry> loadAllLockSafe() throws CacheLoaderException;

    protected abstract Set<InternalCacheEntry> loadLockSafe(int var1) throws CacheLoaderException;

    protected abstract Set<Object> loadAllKeysLockSafe(Set<Object> var1) throws CacheLoaderException;

    protected abstract void toStreamLockSafe(ObjectOutput var1) throws CacheLoaderException;

    protected abstract void fromStreamLockSafe(ObjectInput var1) throws CacheLoaderException;

    protected abstract boolean removeLockSafe(Object var1, String var2) throws CacheLoaderException;

    protected abstract void storeLockSafe(InternalCacheEntry var1, String var2) throws CacheLoaderException;

    protected abstract InternalCacheEntry loadLockSafe(Object var1, String var2) throws CacheLoaderException;

    protected abstract String getLockFromKey(Object var1) throws CacheLoaderException;
}

