/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.CacheException;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.Util;

@DefaultFactoryFor(classes={Transport.class})
public class TransportFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        String transportClass = this.globalConfiguration.getTransportClass();
        try {
            if (transportClass == null) {
                return null;
            }
            return (T)Util.getInstance(transportClass);
        }
        catch (Exception e) {
            throw new CacheException("Unable to create transport of type " + transportClass, e);
        }
    }
}

