/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.distribution.ConsistentHashHelper;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.distribution.InMemoryStateMap;
import org.infinispan.distribution.PendingPreparesMap;
import org.infinispan.distribution.RehashTask;
import org.infinispan.distribution.TransactionLogMap;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.loaders.CacheStore;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ReadOnlyDataContainerBackedKeySet;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.NotifyingFutureImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LeaveTask
extends RehashTask {
    private static final Log log = LogFactory.getLog(LeaveTask.class);
    private static final boolean trace = log.isTraceEnabled();
    private final List<Address> leavers;
    private final Address self;
    private final List<Address> leaversHandled;

    protected LeaveTask(DistributionManagerImpl dmi, RpcManager rpcManager, Configuration configuration, List<Address> leavers, TransactionLogger transactionLogger, CommandsFactory cf, DataContainer dataContainer) {
        super(dmi, rpcManager, configuration, transactionLogger, cf, dataContainer);
        this.leavers = leavers;
        this.leaversHandled = new LinkedList<Address>(leavers);
        this.self = rpcManager.getTransport().getAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRehash() throws Exception {
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Commencing.  Leavers' list is {0}", this.leavers);
        }
        boolean completedSuccessfully = false;
        LinkedList<Address> leaversHandled = new LinkedList<Address>(this.leavers);
        ConsistentHash oldCH = ConsistentHashHelper.createConsistentHash(this.configuration, this.dmi.getConsistentHash().getCaches(), leaversHandled);
        int replCount = this.configuration.getNumOwners();
        try {
            InMemoryStateMap statemap = new InMemoryStateMap(leaversHandled, this.self, oldCH, this.dmi.getConsistentHash(), replCount);
            if (log.isTraceEnabled()) {
                log.trace("Examining state in data container");
            }
            for (InternalCacheEntry ice : this.dataContainer) {
                List<Address> oldOwners = oldCH.locate(ice.getKey(), replCount);
                for (Address a : oldOwners) {
                    if (!leaversHandled.contains(a)) continue;
                    statemap.addState(ice);
                }
            }
            CacheStore cs = this.dmi.getCacheStoreForRehashing();
            if (cs != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Examining state in cache store");
                }
                for (Object key : cs.loadAllKeys(new ReadOnlyDataContainerBackedKeySet(this.dataContainer))) {
                    statemap.addState(key, cs);
                }
            }
            HashSet<NotifyingFutureImpl> pushFutures = new HashSet<NotifyingFutureImpl>();
            for (Map.Entry entry : statemap.getState().entrySet()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Pushing {0} entries to {1}", ((Map)entry.getValue()).size(), entry.getKey());
                }
                RehashControlCommand push = this.cf.buildRehashControlCommand(this.self, (Map)entry.getValue());
                NotifyingFutureImpl f = new NotifyingFutureImpl(null);
                pushFutures.add(f);
                this.rpcManager.invokeRemotelyInFuture(Collections.singleton(entry.getKey()), push, true, f, this.configuration.getRehashRpcTimeout());
            }
            for (Future future : pushFutures) {
                future.get();
            }
            this.processAndDrainTxLog(oldCH, this.dmi.getConsistentHash(), replCount);
            completedSuccessfully = true;
            this.invalidateInvalidHolders(oldCH, this.dmi.getConsistentHash());
            if (log.isInfoEnabled()) {
                log.info((Object)"Completed in {0}!", Util.prettyPrintTime(System.currentTimeMillis() - start));
            }
        }
        catch (InterruptedException ie) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Interrupted after {0}!  Completed successfully? {1}", Util.prettyPrintTime(System.currentTimeMillis() - start), completedSuccessfully);
            }
        }
        catch (Exception e) {
            log.error((Object)"Caught exception! Completed successfully? {0}", e, completedSuccessfully);
        }
        finally {
            if (completedSuccessfully) {
                this.leavers.removeAll(leaversHandled);
            }
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private void processAndDrainTxLog(ConsistentHash oldCH, ConsistentHash newCH, int replCount) {
        List<WriteCommand> c;
        if (trace) {
            log.trace("Processing transaction log iteratively");
        }
        int i = 0;
        while (this.transactionLogger.shouldDrainWithoutLock()) {
            if (trace) {
                log.trace((Object)"Processing transaction log, iteration {0}", i++);
            }
            c = this.transactionLogger.drain();
            if (trace) {
                log.trace((Object)"Found {0} modifications", c.size());
            }
            this.apply(oldCH, newCH, replCount, c);
        }
        if (trace) {
            log.trace("Processing transaction log: final drain and lock");
        }
        c = this.transactionLogger.drainAndLock();
        if (trace) {
            log.trace((Object)"Found {0} modifications", c.size());
        }
        this.apply(oldCH, newCH, replCount, c);
        if (trace) {
            log.trace("Handling pending prepares");
        }
        PendingPreparesMap state = new PendingPreparesMap(this.leavers, oldCH, newCH, replCount);
        Collection<PrepareCommand> pendingPrepares = this.transactionLogger.getPendingPrepares();
        if (trace) {
            log.trace((Object)"Found {0} pending prepares", pendingPrepares.size());
        }
        for (PrepareCommand pc : pendingPrepares) {
            state.addState(pc);
        }
        if (trace) {
            log.trace((Object)"State map for pending prepares is {0}", state.getState());
        }
        HashSet<NotifyingFutureImpl> pushFutures = new HashSet<NotifyingFutureImpl>();
        for (Map.Entry entry : state.getState().entrySet()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Pushing {0} uncommitted prepares to {1}", ((List)entry.getValue()).size(), entry.getKey());
            }
            RehashControlCommand push = this.cf.buildRehashControlCommandTxLogPendingPrepares(this.self, (List)entry.getValue());
            NotifyingFutureImpl f = new NotifyingFutureImpl(null);
            pushFutures.add(f);
            this.rpcManager.invokeRemotelyInFuture(Collections.singleton(entry.getKey()), push, true, f, this.configuration.getRehashRpcTimeout());
        }
        for (Future future : pushFutures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error((Object)"Error pushing tx log", e);
            }
        }
        if (trace) {
            log.trace("Finished pushing pending prepares; unlocking and disabling transaction logging");
        }
        this.transactionLogger.unlockAndDisable();
    }

    private void apply(ConsistentHash oldCH, ConsistentHash newCH, int replCount, List<WriteCommand> wc) {
        TransactionLogMap state = new TransactionLogMap(this.leavers, oldCH, newCH, replCount);
        for (WriteCommand c : wc) {
            state.addState(c);
        }
        if (trace) {
            log.trace((Object)"State map for modifications is {0}", state.getState());
        }
        HashSet<NotifyingFutureImpl> pushFutures = new HashSet<NotifyingFutureImpl>();
        for (Map.Entry entry : state.getState().entrySet()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Pushing {0} modifications to {1}", ((List)entry.getValue()).size(), entry.getKey());
            }
            RehashControlCommand push = this.cf.buildRehashControlCommandTxLog(this.self, (List)entry.getValue());
            NotifyingFutureImpl f = new NotifyingFutureImpl(null);
            pushFutures.add(f);
            this.rpcManager.invokeRemotelyInFuture(Collections.singleton(entry.getKey()), push, true, f, this.configuration.getRehashRpcTimeout());
        }
        for (Future future : pushFutures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error((Object)"Error pushing tx log", e);
            }
        }
    }

    @Override
    protected Collection<Address> getInvalidHolders(Object key, ConsistentHash chOld, ConsistentHash chNew) {
        Collection<Address> l = super.getInvalidHolders(key, chOld, chNew);
        l.removeAll(this.leaversHandled);
        return l;
    }
}

