/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.infinispan.util.logging.AbstractLogImpl;

public class JDKLogImpl
extends AbstractLogImpl {
    private final Logger logger;

    public JDKLogImpl(String category) {
        this.logger = Logger.getLogger(category);
    }

    private void log(Level level, Object object, Throwable ex) {
        if (this.logger.isLoggable(level)) {
            Throwable dummyException = new Throwable();
            StackTraceElement[] locations = dummyException.getStackTrace();
            String className = "unknown";
            String methodName = "unknown";
            int depth = 2;
            if (locations != null && locations.length > depth) {
                StackTraceElement caller = locations[depth];
                className = caller.getClassName();
                methodName = caller.getMethodName();
            }
            if (ex == null) {
                this.logger.logp(level, className, methodName, String.valueOf(object));
            } else {
                this.logger.logp(level, className, methodName, String.valueOf(object), ex);
            }
        }
    }

    @Override
    public void trace(Object message) {
        this.log(Level.FINER, message, null);
    }

    @Override
    public void debug(Object message) {
        this.log(Level.FINE, message, null);
    }

    @Override
    public void info(Object message) {
        this.log(Level.INFO, message, null);
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARNING, message, null);
    }

    @Override
    public void error(Object message) {
        this.log(Level.SEVERE, message, null);
    }

    @Override
    public void fatal(Object message) {
        this.log(Level.SEVERE, message, null);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.log(Level.FINER, message, t);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }
}

