/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks.containers;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.util.concurrent.locks.containers.LockContainer;

@ThreadSafe
public abstract class AbstractStripedLockContainer
implements LockContainer {
    private int lockSegmentMask;
    private int lockSegmentShift;

    final int calculateNumberOfSegments(int concurrencyLevel) {
        int numLocks;
        int tempLockSegShift = 0;
        for (numLocks = 1; numLocks < concurrencyLevel; numLocks <<= 1) {
            ++tempLockSegShift;
        }
        this.lockSegmentShift = 32 - tempLockSegShift;
        this.lockSegmentMask = numLocks - 1;
        return numLocks;
    }

    final int hashToIndex(Object object) {
        return this.hash(object) >>> this.lockSegmentShift & this.lockSegmentMask;
    }

    final int hash(Object object) {
        int h = object.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    protected abstract void initLocks(int var1);

    @Override
    public Lock acquireLock(Object key, long timeout, TimeUnit unit) throws InterruptedException {
        Lock lock = this.getLock(key);
        return lock.tryLock(timeout, unit) ? lock : null;
    }

    @Override
    public void releaseLock(Object key) {
        this.getLock(key).unlock();
    }
}

