/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClassFinder {
    private static final Log log = LogFactory.getLog(ClassFinder.class);
    public static final String PATH = System.getProperty("java.class.path") + File.pathSeparator + System.getProperty("surefire.test.class.path");

    public static List<Class<?>> withAnnotationPresent(List<Class<?>> classes, Class<? extends Annotation> c) {
        ArrayList clazzes = new ArrayList();
        for (Class<?> clazz : classes) {
            if (!clazz.isAnnotationPresent(c)) continue;
            clazzes.add(clazz);
        }
        return clazzes;
    }

    public static List<Class<?>> withAnnotationDeclared(List<Class<?>> classes, Class<? extends Annotation> c) {
        ArrayList clazzes = new ArrayList();
        for (Class<?> clazz : classes) {
            Annotation[] declaredAnnots;
            if (!clazz.isAnnotationPresent(c)) continue;
            for (Annotation declaredAnnot : declaredAnnots = clazz.getDeclaredAnnotations()) {
                if (!declaredAnnot.annotationType().isAssignableFrom(c)) continue;
                clazzes.add(clazz);
            }
        }
        return clazzes;
    }

    public static List<Class<?>> isAssignableFrom(List<Class<?>> classes, Class<?> clazz) {
        ArrayList clazzes = new ArrayList();
        for (Class<?> c : classes) {
            if (!clazz.isAssignableFrom(c)) continue;
            clazzes.add(c);
        }
        return clazzes;
    }

    public static List<Class<?>> withAnnotationPresent(Class<? extends Annotation> ann) throws Exception {
        return ClassFinder.withAnnotationPresent(ClassFinder.infinispanClasses(), ann);
    }

    public static List<Class<?>> isAssignableFrom(Class<?> clazz) throws Exception {
        return ClassFinder.isAssignableFrom(ClassFinder.infinispanClasses(), clazz);
    }

    public static List<Class<?>> infinispanClasses() throws Exception {
        return ClassFinder.infinispanClasses(PATH);
    }

    public static List<Class<?>> infinispanClasses(String javaClassPath) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (String path : javaClassPath.split(File.pathSeparator)) {
            if (!path.contains("infinispan")) continue;
            files.add(new File(path));
        }
        log.debug("Looking for infinispan classes in " + files);
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet classFiles = new HashSet();
        for (File file : files) {
            classFiles.addAll(ClassFinder.findClassesOnPath(file));
        }
        return new ArrayList(classFiles);
    }

    private static List<Class<?>> findClassesOnPath(File path) {
        ArrayList classes;
        block11: {
            Class claz;
            block10: {
                classes = new ArrayList();
                claz = null;
                if (!path.isDirectory()) break block10;
                ArrayList<File> classFiles = new ArrayList<File>();
                ClassFinder.dir(classFiles, path);
                for (File cf : classFiles) {
                    String clazz = null;
                    try {
                        clazz = ClassFinder.toClassName(cf.getAbsolutePath());
                        claz = Util.loadClass(clazz);
                        classes.add(claz);
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        log.warn(cf.getAbsolutePath() + " has reference to a class " + ncdfe.getMessage() + " that could not be loaded from classpath");
                    }
                    catch (Throwable e) {
                        log.warn((Object)("On path " + cf.getAbsolutePath() + " could not load class " + clazz), e);
                    }
                }
                break block11;
            }
            if (!path.isFile() || !path.getName().endsWith("jar") || !path.canRead()) break block11;
            JarFile jar = null;
            try {
                jar = new JarFile(path);
            }
            catch (Exception ex) {
                log.warn("Could not create jar file on path " + path);
                return classes;
            }
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                if (!entry.getName().endsWith("class")) continue;
                String clazz = null;
                try {
                    clazz = ClassFinder.toClassName(entry.getName());
                    claz = Util.loadClass(clazz);
                    classes.add(claz);
                }
                catch (NoClassDefFoundError ncdfe) {
                    log.warn(entry.getName() + " has reference to a class " + ncdfe.getMessage() + " that could not be loaded from classpath");
                }
                catch (Throwable e) {
                    log.warn((Object)("From jar path " + entry.getName() + " could not load class " + clazz), e);
                }
            }
        }
        return classes;
    }

    private static void dir(List<File> files, File dir) {
        File[] entries;
        for (File entry : entries = dir.listFiles()) {
            if (entry.isDirectory()) {
                ClassFinder.dir(files, entry);
                continue;
            }
            if (!entry.getName().endsWith("class")) continue;
            files.add(entry);
        }
    }

    private static String toClassName(String fileName) {
        return fileName.substring(fileName.lastIndexOf("org"), fileName.length() - 6).replaceAll(File.separatorChar == '\\' ? "\\\\" : File.separator, ".");
    }
}

