/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.marshall.Marshaller;
import org.infinispan.transaction.xa.GlobalTransaction;

public class ChainingCacheStore
implements CacheStore {
    LinkedHashMap<CacheLoader, CacheLoaderConfig> loaders = new LinkedHashMap();
    LinkedHashMap<CacheStore, CacheLoaderConfig> stores = new LinkedHashMap();

    @Override
    public void store(InternalCacheEntry ed) throws CacheLoaderException {
        for (CacheStore s : this.stores.keySet()) {
            s.store(ed);
        }
    }

    @Override
    public void fromStream(ObjectInput inputStream) throws CacheLoaderException {
        for (Map.Entry<CacheStore, CacheLoaderConfig> e : this.stores.entrySet()) {
            if (!(e.getValue() instanceof CacheStoreConfig) || !((CacheStoreConfig)e.getValue()).isFetchPersistentState().booleanValue()) continue;
            e.getKey().fromStream(inputStream);
            break;
        }
    }

    @Override
    public void toStream(ObjectOutput outputStream) throws CacheLoaderException {
        for (Map.Entry<CacheStore, CacheLoaderConfig> e : this.stores.entrySet()) {
            if (!(e.getValue() instanceof CacheStoreConfig) || !((CacheStoreConfig)e.getValue()).isFetchPersistentState().booleanValue()) continue;
            e.getKey().toStream(outputStream);
            break;
        }
    }

    @Override
    public void clear() throws CacheLoaderException {
        for (CacheStore s : this.stores.keySet()) {
            s.clear();
        }
    }

    @Override
    public boolean remove(Object key) throws CacheLoaderException {
        boolean r = false;
        for (CacheStore s : this.stores.keySet()) {
            r = s.remove(key) || r;
        }
        return r;
    }

    @Override
    public void removeAll(Set<Object> keys) throws CacheLoaderException {
        for (CacheStore s : this.stores.keySet()) {
            s.removeAll(keys);
        }
    }

    @Override
    public void purgeExpired() throws CacheLoaderException {
        for (CacheStore s : this.stores.keySet()) {
            s.purgeExpired();
        }
    }

    @Override
    public void commit(GlobalTransaction tx) throws CacheLoaderException {
        for (CacheStore s : this.stores.keySet()) {
            s.commit(tx);
        }
    }

    @Override
    public void rollback(GlobalTransaction tx) {
        for (CacheStore s : this.stores.keySet()) {
            s.rollback(tx);
        }
    }

    @Override
    public void prepare(List<? extends Modification> list, GlobalTransaction tx, boolean isOnePhase) throws CacheLoaderException {
        for (CacheStore s : this.stores.keySet()) {
            s.prepare(list, tx, isOnePhase);
        }
    }

    public void init(CacheLoaderConfig config, Cache cache, Marshaller m) throws CacheLoaderException {
        for (Map.Entry<CacheLoader, CacheLoaderConfig> e : this.loaders.entrySet()) {
            e.getKey().init(e.getValue(), cache, m);
        }
    }

    @Override
    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        CacheLoader l;
        InternalCacheEntry se = null;
        Iterator<CacheLoader> i$ = this.loaders.keySet().iterator();
        while (i$.hasNext() && (se = (l = i$.next()).load(key)) == null) {
        }
        return se;
    }

    @Override
    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        HashSet<InternalCacheEntry> set = new HashSet<InternalCacheEntry>();
        for (CacheStore s : this.stores.keySet()) {
            set.addAll(s.loadAll());
        }
        return set;
    }

    @Override
    public boolean containsKey(Object key) throws CacheLoaderException {
        for (CacheLoader l : this.loaders.keySet()) {
            if (!l.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return null;
    }

    @Override
    public void start() throws CacheLoaderException {
        for (CacheLoader l : this.loaders.keySet()) {
            l.start();
        }
    }

    @Override
    public void stop() throws CacheLoaderException {
        for (CacheLoader l : this.loaders.keySet()) {
            l.stop();
        }
    }

    public void addCacheLoader(CacheLoader loader, CacheLoaderConfig config) {
        this.loaders.put(loader, config);
        if (loader instanceof CacheStore) {
            this.stores.put((CacheStore)loader, config);
        }
    }

    public void purgeIfNecessary() throws CacheLoaderException {
        for (Map.Entry<CacheStore, CacheLoaderConfig> e : this.stores.entrySet()) {
            CacheLoaderConfig value = e.getValue();
            if (!(value instanceof CacheStoreConfig) || !((CacheStoreConfig)value).isPurgeOnStartup().booleanValue()) continue;
            e.getKey().clear();
        }
    }

    public LinkedHashMap<CacheStore, CacheLoaderConfig> getStores() {
        return this.stores;
    }

    @Override
    public CacheStoreConfig getCacheStoreConfig() {
        return null;
    }
}

