/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.bucket;

import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.LockSupportCacheStore;
import org.infinispan.loaders.bucket.Bucket;

public abstract class BucketBasedCacheStore
extends LockSupportCacheStore {
    @Override
    protected InternalCacheEntry loadLockSafe(Object key, String lockingKey) throws CacheLoaderException {
        Bucket bucket = this.loadBucket(lockingKey);
        if (bucket == null) {
            return null;
        }
        InternalCacheEntry se = bucket.getEntry(key);
        if (se != null && se.isExpired()) {
            return null;
        }
        return se;
    }

    @Override
    protected void storeLockSafe(InternalCacheEntry entry, String lockingKey) throws CacheLoaderException {
        Bucket bucket = this.loadBucket(lockingKey);
        if (bucket != null) {
            bucket.addEntry(entry);
            this.updateBucket(bucket);
        } else {
            bucket = new Bucket();
            bucket.setBucketName(lockingKey);
            bucket.addEntry(entry);
            this.insertBucket(bucket);
        }
    }

    @Override
    protected boolean removeLockSafe(Object key, String lockingKey) throws CacheLoaderException {
        Bucket bucket = this.loadBucket(lockingKey);
        if (bucket == null) {
            return false;
        }
        boolean success = bucket.removeEntry(key);
        if (success) {
            this.updateBucket(bucket);
        }
        return success;
    }

    @Override
    protected String getLockFromKey(Object key) {
        return String.valueOf(key.hashCode());
    }

    protected abstract void insertBucket(Bucket var1) throws CacheLoaderException;

    protected abstract void updateBucket(Bucket var1) throws CacheLoaderException;

    protected abstract Bucket loadBucket(String var1) throws CacheLoaderException;
}

