/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class UnsignedNumeric {
    public static int readUnsignedInt(ObjectInput in) throws IOException {
        byte b = in.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            i = (int)((long)i | ((long)b & 0x7FL) << shift);
            shift += 7;
        }
        return i;
    }

    public static void writeUnsignedInt(ObjectOutput out, int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            out.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        out.writeByte((byte)i);
    }

    public static long readUnsignedLong(ObjectInput in) throws IOException {
        byte b = in.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public static void writeUnsignedLong(ObjectOutput out, long i) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        out.writeByte((byte)i);
    }

    public static int readUnsignedInt(byte[] bytes, int offset) throws IOException {
        byte b = bytes[offset++];
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = bytes[offset++];
            i = (int)((long)i | ((long)b & 0x7FL) << shift);
            shift += 7;
        }
        return i;
    }

    public static void writeUnsignedInt(byte[] bytes, int offset, int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            bytes[offset++] = (byte)(i & 0x7F | 0x80);
            i >>>= 7;
        }
        bytes[offset] = (byte)i;
    }

    public static long readUnsignedLong(byte[] bytes, int offset) throws IOException {
        byte b = bytes[offset++];
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = bytes[offset++];
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public static void writeUnsignedLong(byte[] bytes, int offset, long i) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            bytes[offset++] = (byte)(i & 0x7FL | 0x80L);
            i >>>= 7;
        }
        bytes[offset] = (byte)i;
    }
}

