/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.distribution.ConsistentHash;
import org.infinispan.distribution.StateMap;
import org.infinispan.remoting.transport.Address;

class InMemoryStateMap
extends StateMap<Map<Object, InternalCacheValue>> {
    Address self;
    Set<Object> keysHandled = new HashSet<Object>();

    InMemoryStateMap(List<Address> leavers, Address self, ConsistentHash oldCH, ConsistentHash newCH, int replCount) {
        super(leavers, oldCH, newCH, replCount);
        this.self = self;
    }

    void addState(InternalCacheEntry payload) {
        Object key = payload.getKey();
        for (Address leaver : this.leavers) {
            boolean isLeaverLast;
            List<Address> owners = this.oldCH.locate(key, this.replCount);
            int leaverIndex = owners.indexOf(leaver);
            if (leaverIndex <= -1) continue;
            int numOwners = owners.size();
            int selfIndex = owners.indexOf(this.self);
            boolean bl = isLeaverLast = leaverIndex == numOwners - 1;
            if ((!isLeaverLast || selfIndex != numOwners - 2) && (isLeaverLast || selfIndex != leaverIndex + 1)) continue;
            List<Address> newOwners = this.newCH.locate(key, this.replCount);
            newOwners.removeAll(owners);
            if (newOwners.isEmpty()) continue;
            for (Address no : newOwners) {
                HashMap<Object, InternalCacheValue> s = (HashMap<Object, InternalCacheValue>)this.state.get(no);
                if (s == null) {
                    s = new HashMap<Object, InternalCacheValue>();
                    this.state.put(no, s);
                }
                s.put(key, payload.toInternalCacheValue());
            }
        }
        this.keysHandled.add(key);
    }

    boolean doesNotContainKey(Object key) {
        return !this.keysHandled.contains(key);
    }
}

