/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.Comparator;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.container.FIFOSimpleDataContainer;
import org.infinispan.container.entries.InternalCacheEntry;

@ThreadSafe
public class LRUSimpleDataContainer
extends FIFOSimpleDataContainer {
    public LRUSimpleDataContainer(int concurrencyLevel) {
        super(concurrencyLevel, false, true, new LRUComparator(1000));
    }

    public LRUSimpleDataContainer(int concurrencyLevel, int timestampGranularity) {
        super(concurrencyLevel, false, true, new LRUComparator(timestampGranularity));
    }

    private static final class LRUComparator
    implements Comparator<InternalCacheEntry> {
        int timestampGranularity;

        private LRUComparator(int timestampGranularity) {
            this.timestampGranularity = timestampGranularity;
        }

        @Override
        public int compare(InternalCacheEntry o1, InternalCacheEntry o2) {
            return (int)o1.getLastUsed() / this.timestampGranularity - (int)o2.getLastUsed() / this.timestampGranularity;
        }
    }
}

