/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.infinispan.util.logging.AbstractLogImpl;

public class Log4JLogImpl
extends AbstractLogImpl {
    private final Logger logger;
    private static final Level TRACE;

    public Log4JLogImpl(String category) {
        this.logger = Logger.getLogger((String)category);
    }

    @Override
    public void trace(Object message) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)TRACE, message, null);
    }

    @Override
    public void debug(Object message) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.DEBUG, message, null);
    }

    @Override
    public void info(Object message) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.INFO, message, null);
    }

    @Override
    public void warn(Object message) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.WARN, message, null);
    }

    @Override
    public void error(Object message) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.ERROR, message, null);
    }

    @Override
    public void fatal(Object message) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.FATAL, message, null);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)TRACE, message, t);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.DEBUG, message, t);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.INFO, message, t);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.WARN, message, t);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.ERROR, message, t);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.logger.log(Log4JLogImpl.class.getName(), (Priority)Level.FATAL, message, t);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isEnabledFor((Priority)TRACE);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isEnabledFor((Priority)Level.DEBUG);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isEnabledFor((Priority)Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isEnabledFor((Priority)Level.FATAL);
    }

    static {
        Object trace;
        try {
            trace = Level.class.getDeclaredField("TRACE").get(null);
        }
        catch (Exception e) {
            trace = Level.DEBUG;
        }
        TRACE = trace;
    }
}

