/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.DeadlockDetectingGlobalTransaction;
import org.infinispan.util.concurrent.locks.DeadlockDetectedException;
import org.infinispan.util.concurrent.locks.LockManagerImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(description="Information about the number of deadlocks that were detected")
public class DeadlockDetectingLockManager
extends LockManagerImpl {
    private static final Log log = LogFactory.getLog(DeadlockDetectingLockManager.class);
    protected volatile long spinDuration;
    protected volatile boolean exposeJmxStats;
    private volatile boolean isSync;
    private AtomicLong detectedRemoteDeadlocks = new AtomicLong(0L);
    private AtomicLong detectedLocalDeadlocks = new AtomicLong(0L);
    private AtomicLong locallyInterruptedTransactions = new AtomicLong(0L);
    private AtomicLong overlapWithNotDeadlockAwareLockOwners = new AtomicLong(0L);

    @Start
    public void init() {
        this.spinDuration = this.configuration.getDeadlockDetectionSpinDuration();
        this.exposeJmxStats = this.configuration.isExposeJmxStatistics();
        this.isSync = this.configuration.getCacheMode().isSynchronous();
    }

    @Override
    public boolean lockAndRecord(Object key, InvocationContext ctx) throws InterruptedException {
        long lockTimeout = this.getLockAcquisitionTimeout(ctx);
        if (trace) {
            log.trace((Object)"Attempting to lock {0} with acquisition timeout of {1} millis", key, lockTimeout);
        }
        if (ctx.isInTxScope()) {
            long now;
            if (trace) {
                log.trace("Using early dead lock detection");
            }
            long start = System.currentTimeMillis();
            while ((now = System.currentTimeMillis()) < start + lockTimeout) {
                Object owner;
                if (this.lockContainer.acquireLock(key, this.spinDuration, TimeUnit.MILLISECONDS)) {
                    if (trace) {
                        log.trace("successfully acquired lock on " + key + ", returning ...");
                    }
                    return true;
                }
                if (trace) {
                    log.trace("Could not acquire lock on '" + key + "' as it is locked by '" + this.getOwner(key) + "', check for dead locks");
                }
                if (!((owner = this.getOwner(key)) instanceof DeadlockDetectingGlobalTransaction)) {
                    if (trace) {
                        log.trace("Owner is not instance of DeadlockDetectingGlobalTransaction: " + owner + ", continuing ...");
                    }
                    if (!this.exposeJmxStats) continue;
                    this.overlapWithNotDeadlockAwareLockOwners.incrementAndGet();
                    continue;
                }
                DeadlockDetectingGlobalTransaction lockOwnerTx = (DeadlockDetectingGlobalTransaction)owner;
                if (this.isSync && !ctx.isOriginLocal() && !lockOwnerTx.isRemote()) {
                    return this.remoteVsRemoteDld(key, ctx, lockTimeout, start, now, lockOwnerTx);
                }
                if ((!ctx.isOriginLocal() || lockOwnerTx.isRemote()) && (this.isSync || ctx.isOriginLocal() || lockOwnerTx.isRemote())) continue;
                this.localVsLocalDld(ctx, lockOwnerTx);
            }
        } else if (this.lockContainer.acquireLock(key, lockTimeout, TimeUnit.MILLISECONDS)) {
            return true;
        }
        return false;
    }

    private void localVsLocalDld(InvocationContext ctx, DeadlockDetectingGlobalTransaction lockOwnerTx) {
        if (trace) {
            log.trace("Looking for local vs local deadlocks");
        }
        DeadlockDetectingGlobalTransaction thisThreadsTx = (DeadlockDetectingGlobalTransaction)ctx.getLockOwner();
        boolean weOwnLock = this.ownsLock(lockOwnerTx.getLockInterntion(), thisThreadsTx);
        if (trace) {
            log.trace("Other owner's intention is " + lockOwnerTx.getLockInterntion() + ". Do we(" + thisThreadsTx + ") own lock for it? " + weOwnLock + ". Lock owner is " + this.getOwner(lockOwnerTx.getLockInterntion()));
        }
        if (weOwnLock) {
            boolean iShouldInterrupt = thisThreadsTx.thisWillInterrupt(lockOwnerTx);
            if (trace) {
                log.trace("deadlock situation detected. Shall I interrupt?" + iShouldInterrupt);
            }
            if (iShouldInterrupt) {
                lockOwnerTx.interruptProcessingThread();
                if (this.exposeJmxStats) {
                    this.detectedLocalDeadlocks.incrementAndGet();
                }
            }
        }
    }

    private boolean remoteVsRemoteDld(Object key, InvocationContext ctx, long lockTimeout, long start, long now, DeadlockDetectingGlobalTransaction lockOwnerTx) throws InterruptedException {
        boolean isDeadLock;
        TxInvocationContext remoteTxContext = (TxInvocationContext)ctx;
        Address origin = remoteTxContext.getGlobalTransaction().getAddress();
        DeadlockDetectingGlobalTransaction remoteGlobalTransaction = (DeadlockDetectingGlobalTransaction)ctx.getLockOwner();
        boolean thisShouldInterrupt = remoteGlobalTransaction.thisWillInterrupt(lockOwnerTx);
        if (trace) {
            log.trace("Should I interrupt other transaction ? " + thisShouldInterrupt);
        }
        boolean bl = isDeadLock = (this.configuration.getCacheMode().isReplicated() || lockOwnerTx.isReplicatingTo(origin)) && !lockOwnerTx.isRemote();
        if (thisShouldInterrupt && isDeadLock) {
            lockOwnerTx.interruptProcessingThread();
            if (this.exposeJmxStats) {
                this.detectedRemoteDeadlocks.incrementAndGet();
                this.locallyInterruptedTransactions.incrementAndGet();
            }
            return this.lockForTheRemainingTime(key, lockTimeout, start, now);
        }
        if (!isDeadLock) {
            return this.lockForTheRemainingTime(key, lockTimeout, start, now);
        }
        if (trace) {
            log.trace("Not trying to acquire lock anymore, as we're in deadlock and this will be rollback at origin");
        }
        if (this.exposeJmxStats) {
            this.detectedRemoteDeadlocks.incrementAndGet();
        }
        remoteGlobalTransaction.setMarkedForRollback(true);
        throw new DeadlockDetectedException("Deadlock situation detected on tx: " + remoteTxContext.getLockOwner());
    }

    private boolean lockForTheRemainingTime(Object key, long lockTimeout, long start, long now) throws InterruptedException {
        long remainingLockingTime = start + lockTimeout - now;
        if (remainingLockingTime < 0L) {
            throw new IllegalStateException("No remaining time!!! The outer while condition MUST make sure this always stands true!");
        }
        if (trace) {
            log.trace("trying to lock for the remaining time: " + remainingLockingTime + " millis ");
        }
        return this.lockContainer.acquireLock(key, remainingLockingTime, TimeUnit.MILLISECONDS);
    }

    public void setExposeJmxStats(boolean exposeJmxStats) {
        this.exposeJmxStats = exposeJmxStats;
    }

    @ManagedAttribute(description="Number of situtations when we try to determine a deadlock and the other lock owner is e.g. a local tx. In this scenario we cannot run the deadlock detection mechanism")
    public long getOverlapWithNotDeadlockAwareLockOwners() {
        return this.overlapWithNotDeadlockAwareLockOwners.get();
    }

    @ManagedAttribute(description="Number of locally originated transactions that were interrupted as a deadlock situation was detected")
    public long getLocallyInterruptedTransactions() {
        return this.locallyInterruptedTransactions.get();
    }

    @ManagedAttribute(description="Number of remote deadlocks detected")
    public long getDetectedRemoteDeadlocks() {
        return this.detectedRemoteDeadlocks.get();
    }

    @ManagedAttribute(description="Number of local detected deadlocks")
    public long getDetectedLocalDeadlocks() {
        return this.detectedLocalDeadlocks.get();
    }

    @ManagedAttribute(description="Total number of local detected deadlocks")
    public long getTotalNumberOfDetectedDeadlocks() {
        return this.detectedRemoteDeadlocks.get() + this.detectedLocalDeadlocks.get();
    }

    @ManagedOperation(description="Resets statistics gathered by this component")
    public void resetStatistics() {
        this.overlapWithNotDeadlockAwareLockOwners.set(0L);
        this.locallyInterruptedTransactions.set(0L);
        this.detectedRemoteDeadlocks.set(0L);
        this.detectedLocalDeadlocks.set(0L);
    }
}

