/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;

public class NotifyingFutureImpl
implements NotifyingNotifiableFuture<Object> {
    final Object actualReturnValue;
    volatile Future<Object> ioFuture;
    volatile boolean callCompleted = false;
    final Set<FutureListener<Object>> listeners = new CopyOnWriteArraySet<FutureListener<Object>>();

    public NotifyingFutureImpl(Object actualReturnValue) {
        this.actualReturnValue = actualReturnValue;
    }

    @Override
    public void setNetworkFuture(Future<Object> future) {
        this.ioFuture = future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.ioFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.ioFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.ioFuture.isDone();
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        this.ioFuture.get();
        return this.actualReturnValue;
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.ioFuture.get(timeout, unit);
        return this.actualReturnValue;
    }

    @Override
    public void notifyDone() {
        this.callCompleted = true;
        for (FutureListener<Object> l : this.listeners) {
            l.futureDone(this);
        }
    }

    @Override
    public NotifyingFuture<Object> attachListener(FutureListener<Object> objectFutureListener) {
        if (!this.callCompleted) {
            this.listeners.add(objectFutureListener);
        }
        if (this.callCompleted) {
            objectFutureListener.futureDone(this);
        }
        return this;
    }
}

