/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.infinispan.util.AbstractMap;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.ReversibleOrderedSet;

public class InfinispanCollections {
    private static final ReversibleOrderedSet EMPTY_ROS = new EmptyReversibleOrderedSet();
    private static final BidirectionalMap EMPTY_BIDI_MAP = new EmptyBidiMap();

    public static final <T> ReversibleOrderedSet<T> emptyReversibleOrderedSet() {
        return EMPTY_ROS;
    }

    public static final <K, V> BidirectionalMap<K, V> emptyBidirectionalMap() {
        return EMPTY_BIDI_MAP;
    }

    private static final class EmptyBidiMap
    extends AbstractMap
    implements BidirectionalMap {
        private EmptyBidiMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public ReversibleOrderedSet keySet() {
            return EMPTY_ROS;
        }

        @Override
        public Collection values() {
            return Collections.emptySet();
        }

        public ReversibleOrderedSet entrySet() {
            return EMPTY_ROS;
        }
    }

    private static final class EmptyReversibleOrderedSet
    extends AbstractSet
    implements ReversibleOrderedSet {
        Iterator it = new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };

        private EmptyReversibleOrderedSet() {
        }

        @Override
        public Iterator iterator() {
            return this.it;
        }

        @Override
        public int size() {
            return 0;
        }

        public Iterator reverseIterator() {
            return this.it;
        }
    }
}

