/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.BidirectionalLinkedHashMap;
import org.infinispan.util.BidirectionalMap;

public class RemoteTransaction
implements CacheTransaction,
Cloneable {
    private List<WriteCommand> modifications;
    private BidirectionalLinkedHashMap<Object, CacheEntry> lookedUpEntries;
    private GlobalTransaction tx;

    public RemoteTransaction(WriteCommand[] modifications, GlobalTransaction tx) {
        this.modifications = Arrays.asList(modifications);
        this.lookedUpEntries = new BidirectionalLinkedHashMap(modifications.length);
        this.tx = tx;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.tx;
    }

    @Override
    public List<WriteCommand> getModifications() {
        return this.modifications;
    }

    public void setModifications(WriteCommand[] modifications) {
        this.modifications = Arrays.asList(modifications);
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        return this.lookedUpEntries.get(key);
    }

    @Override
    public BidirectionalMap<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> lookedUpEntries) {
        lookedUpEntries.putAll(lookedUpEntries);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        this.lookedUpEntries.remove(key);
    }

    @Override
    public void clearLookedUpEntries() {
        this.lookedUpEntries.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteTransaction)) {
            return false;
        }
        RemoteTransaction that = (RemoteTransaction)o;
        return this.tx.equals(that.tx);
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public Object clone() {
        try {
            RemoteTransaction dolly = (RemoteTransaction)super.clone();
            dolly.modifications = new ArrayList<WriteCommand>(this.modifications);
            dolly.lookedUpEntries = this.lookedUpEntries.clone();
            return dolly;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!!");
        }
    }

    public String toString() {
        return "RemoteTransaction{modifications=" + this.modifications + ", lookedUpEntries=" + this.lookedUpEntries + ", tx=" + this.tx + '}';
    }
}

