/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.Random;
import org.infinispan.config.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.DeadlockDetectingGlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;

public class GlobalTransactionFactory {
    private boolean isEddEnabled = false;
    private final Random rnd = new Random();

    private long generateRandomdId() {
        return this.rnd.nextLong();
    }

    public GlobalTransactionFactory() {
    }

    public GlobalTransactionFactory(boolean eddEnabled) {
        this.isEddEnabled = eddEnabled;
    }

    @Inject
    public void init(Configuration configuration) {
        this.isEddEnabled = configuration.isEnableDeadlockDetection();
    }

    @Start
    public void start() {
    }

    public GlobalTransaction instantiateGlobalTransaction() {
        if (this.isEddEnabled) {
            return new DeadlockDetectingGlobalTransaction();
        }
        return new GlobalTransaction();
    }

    public GlobalTransaction newGlobalTransaction(Address addr, boolean remote) {
        GlobalTransaction gtx;
        if (this.isEddEnabled) {
            DeadlockDetectingGlobalTransaction globalTransaction = new DeadlockDetectingGlobalTransaction(addr, remote);
            globalTransaction.setCoinToss(this.generateRandomdId());
            gtx = globalTransaction;
        } else {
            gtx = new GlobalTransaction(addr, remote);
        }
        return gtx;
    }
}

