/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.remoting.transport.DistributedSync;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class JGroupsDistSync
implements DistributedSync {
    private final ReentrantReadWriteLock processingLock = new ReentrantReadWriteLock();
    private final ReclosableLatch flushBlockGate = new ReclosableLatch(true);
    private final AtomicInteger flushBlockGateCount = new AtomicInteger(0);
    private final AtomicInteger flushWaitGateCount = new AtomicInteger(0);
    private final ReclosableLatch flushWaitGate = new ReclosableLatch(false);
    private final ReclosableLatch joinInProgress = new ReclosableLatch(false);
    private static final Log log = LogFactory.getLog(JGroupsDistSync.class);
    public static final boolean trace = log.isTraceEnabled();

    public void blockUntilNoJoinsInProgress() {
        while (Thread.currentThread().isInterrupted()) {
            try {
                this.joinInProgress.await();
                return;
            }
            catch (InterruptedException ie) {
                if (trace) {
                    log.trace("Interrupted while waiting for the joinInProgress gate");
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public DistributedSync.SyncResponse blockUntilAcquired(long timeout, TimeUnit timeUnit) throws TimeoutException {
        int initState = this.flushWaitGateCount.get();
        while (true) {
            try {
                if (!this.flushWaitGate.await(timeout, timeUnit)) {
                    throw new TimeoutException("Timed out waiting for a cluster-wide sync to be acquired. (timeout = " + Util.prettyPrintTime(timeout) + ")");
                }
                return initState == this.flushWaitGateCount.get() ? DistributedSync.SyncResponse.STATE_PREEXISTED : DistributedSync.SyncResponse.STATE_ACHIEVED;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    @Override
    public DistributedSync.SyncResponse blockUntilReleased(long timeout, TimeUnit timeUnit) throws TimeoutException {
        int initState = this.flushBlockGateCount.get();
        while (true) {
            try {
                if (!this.flushBlockGate.await(timeout, timeUnit)) {
                    throw new TimeoutException("Timed out waiting for a cluster-wide sync to be released. (timeout = " + Util.prettyPrintTime(timeout) + ")");
                }
                return initState == this.flushWaitGateCount.get() ? DistributedSync.SyncResponse.STATE_PREEXISTED : DistributedSync.SyncResponse.STATE_ACHIEVED;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    @Override
    public void acquireSync() {
        this.flushBlockGate.close();
        this.flushWaitGateCount.incrementAndGet();
        this.flushWaitGate.open();
    }

    @Override
    public void releaseSync() {
        this.flushWaitGate.close();
        this.flushBlockGateCount.incrementAndGet();
        this.flushBlockGate.open();
    }

    @Override
    public void acquireProcessingLock(boolean exclusive, long timeout, TimeUnit timeUnit) throws TimeoutException {
        while (true) {
            try {
                Lock lock;
                Lock lock2 = lock = exclusive ? this.processingLock.writeLock() : this.processingLock.readLock();
                if (!lock.tryLock(timeout, timeUnit)) {
                    throw new TimeoutException("Could not obtain " + (exclusive ? "exclusive" : "shared") + " processing lock");
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    @Override
    public void releaseProcessingLock() {
        block4: {
            try {
                if (this.processingLock.isWriteLockedByCurrentThread()) {
                    this.processingLock.writeLock().unlock();
                } else {
                    this.processingLock.readLock().unlock();
                }
            }
            catch (IllegalMonitorStateException imse) {
                if (!log.isTraceEnabled()) break block4;
                log.trace("Did not own lock!");
            }
        }
    }

    public void signalJoinInProgress() {
        if (trace) {
            log.trace("Closing joinInProgress gate");
        }
        this.joinInProgress.close();
    }

    public void signalJoinCompleted() {
        if (trace) {
            log.trace("Releasing " + this.joinInProgress + " gate");
        }
        this.joinInProgress.open();
    }
}

