/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.responses.UnsureResponse;

public class DistributionResponseGenerator
implements ResponseGenerator {
    DistributionManager distributionManager;

    @Inject
    public void inject(DistributionManager distributionManager) {
        this.distributionManager = distributionManager;
    }

    @Override
    public Response getResponse(CacheRpcCommand command, Object returnValue) {
        SingleRpcCommand src;
        ReplicableCommand c;
        if (command instanceof ClusteredGetCommand) {
            ClusteredGetCommand clusteredGet = (ClusteredGetCommand)command;
            if (this.distributionManager.isAffectedByRehash(clusteredGet.getKey())) {
                return new UnsureResponse();
            }
            return returnValue == null ? null : new SuccessfulResponse(returnValue);
        }
        if (command instanceof SingleRpcCommand && (c = (src = (SingleRpcCommand)command).getCommand()) instanceof WriteCommand) {
            if (((WriteCommand)c).isSuccessful()) {
                return new SuccessfulResponse(returnValue);
            }
            return UnsuccessfulResponse.INSTANCE;
        }
        return new SuccessfulResponse(returnValue);
    }
}

