/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.config.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReplicationQueue {
    private static final Log log = LogFactory.getLog(ReplicationQueue.class);
    private long maxElements = 500L;
    private final List<ReplicableCommand> elements = new LinkedList<ReplicableCommand>();
    private ScheduledExecutorService scheduledExecutor = null;
    private RpcManager rpcManager;
    private Configuration configuration;
    private boolean enabled;
    private CommandsFactory commandsFactory;
    private boolean stateTransferEnabled;

    public boolean isEnabled() {
        return this.enabled;
    }

    @Inject
    private void injectDependencies(@ComponentName(value="org.infinispan.executors.replicationQueue") ScheduledExecutorService executor, RpcManager rpcManager, Configuration configuration, CommandsFactory commandsFactory) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.commandsFactory = commandsFactory;
        this.scheduledExecutor = executor;
    }

    @Start
    public synchronized void start() {
        this.stateTransferEnabled = this.configuration.isStateTransferEnabled();
        long interval = this.configuration.getReplQueueInterval();
        log.trace((Object)"Starting replication queue, with interval {0} and maxElements {1}", interval, this.maxElements);
        this.maxElements = this.configuration.getReplQueueMaxElements();
        this.enabled = this.configuration.isUseReplQueue();
        if (this.enabled && interval > 0L) {
            this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ReplicationQueue.this.flush();
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
        }
    }

    @Stop
    public synchronized void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
        this.scheduledExecutor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ReplicableCommand job) {
        if (job == null) {
            throw new NullPointerException("job is null");
        }
        List<ReplicableCommand> list = this.elements;
        synchronized (list) {
            this.elements.add(job);
            if ((long)this.elements.size() >= this.maxElements) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ArrayList<ReplicableCommand> toReplicate;
        List<ReplicableCommand> list = this.elements;
        synchronized (list) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"flush(): flushing repl queue (num elements={0})", this.elements.size());
            }
            toReplicate = new ArrayList<ReplicableCommand>(this.elements);
            this.elements.clear();
        }
        int toReplicateSize = toReplicate.size();
        if (toReplicateSize > 0) {
            try {
                log.trace((Object)"Flushing {0} elements", toReplicateSize);
                MultipleRpcCommand multipleRpcCommand = this.commandsFactory.buildReplicateCommand(toReplicate);
                this.rpcManager.invokeRemotely(null, (ReplicableCommand)multipleRpcCommand, ResponseMode.ASYNCHRONOUS, this.configuration.getSyncReplTimeout());
            }
            catch (Throwable t) {
                log.error((Object)("failed replicating " + toReplicate.size() + " elements in replication queue"), t);
            }
        }
    }

    public int getElementsCount() {
        return this.elements.size();
    }

    public void reset() {
        this.elements.clear();
    }
}

