/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.infinispan.Cache;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.notifications.AbstractListenerImpl;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryLoadedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.EventImpl;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheNotifierImpl
extends AbstractListenerImpl
implements CacheNotifier {
    private static final Log log = LogFactory.getLog(CacheNotifierImpl.class);
    private static final Map<Class<? extends Annotation>, Class> allowedListeners = new HashMap<Class<? extends Annotation>, Class>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryCreatedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryRemovedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryVisitedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryModifiedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryActivatedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryPassivatedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryLoadedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryInvalidatedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> cacheEntryEvictedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> transactionRegisteredListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    final List<AbstractListenerImpl.ListenerInvocation> transactionCompletedListeners = new CopyOnWriteArrayList<AbstractListenerImpl.ListenerInvocation>();
    private InvocationContextContainer icc;
    private Cache cache;

    public CacheNotifierImpl() {
        this.listenersMap.put(CacheEntryCreated.class, this.cacheEntryCreatedListeners);
        this.listenersMap.put(CacheEntryRemoved.class, this.cacheEntryRemovedListeners);
        this.listenersMap.put(CacheEntryVisited.class, this.cacheEntryVisitedListeners);
        this.listenersMap.put(CacheEntryModified.class, this.cacheEntryModifiedListeners);
        this.listenersMap.put(CacheEntryActivated.class, this.cacheEntryActivatedListeners);
        this.listenersMap.put(CacheEntryPassivated.class, this.cacheEntryPassivatedListeners);
        this.listenersMap.put(CacheEntryLoaded.class, this.cacheEntryLoadedListeners);
        this.listenersMap.put(CacheEntryEvicted.class, this.cacheEntryEvictedListeners);
        this.listenersMap.put(TransactionRegistered.class, this.transactionRegisteredListeners);
        this.listenersMap.put(TransactionCompleted.class, this.transactionCompletedListeners);
        this.listenersMap.put(CacheEntryInvalidated.class, this.cacheEntryInvalidatedListeners);
    }

    @Inject
    void injectDependencies(InvocationContextContainer icc, Cache cache) {
        this.icc = icc;
        this.cache = cache;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Map<Class<? extends Annotation>, Class> getAllowedMethodAnnotations() {
        return allowedListeners;
    }

    @Override
    public void notifyCacheEntryCreated(Object key, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryCreatedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            InvocationContext contexts = this.icc.suspend();
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            this.setTx(ctx, e);
            e.setType(Event.Type.CACHE_ENTRY_CREATED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryCreatedListeners) {
                listener.invoke(e);
            }
            this.icc.resume(contexts);
        }
    }

    @Override
    public void notifyCacheEntryModified(Object key, Object value, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryModifiedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            InvocationContext contexts = this.icc.suspend();
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setValue(value);
            e.setPre(pre);
            e.setKey(key);
            this.setTx(ctx, e);
            e.setType(Event.Type.CACHE_ENTRY_MODIFIED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryModifiedListeners) {
                listener.invoke(e);
            }
            this.icc.resume(contexts);
        }
    }

    @Override
    public void notifyCacheEntryRemoved(Object key, Object value, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryRemovedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            InvocationContext contexts = this.icc.suspend();
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setValue(value);
            e.setPre(pre);
            e.setKey(key);
            this.setTx(ctx, e);
            e.setType(Event.Type.CACHE_ENTRY_REMOVED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryRemovedListeners) {
                listener.invoke(e);
            }
            this.icc.resume(contexts);
        }
    }

    @Override
    public void notifyCacheEntryVisited(Object key, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryVisitedListeners.isEmpty()) {
            InvocationContext contexts = this.icc.suspend();
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setPre(pre);
            e.setKey(key);
            this.setTx(ctx, e);
            e.setType(Event.Type.CACHE_ENTRY_VISITED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryVisitedListeners) {
                listener.invoke(e);
            }
            this.icc.resume(contexts);
        }
    }

    @Override
    public void notifyCacheEntryEvicted(Object key, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryEvictedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            InvocationContext contexts = this.icc.suspend();
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            this.setTx(ctx, e);
            e.setType(Event.Type.CACHE_ENTRY_EVICTED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryEvictedListeners) {
                listener.invoke(e);
            }
            this.icc.resume(contexts);
        }
    }

    @Override
    public void notifyCacheEntryInvalidated(Object key, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryInvalidatedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            InvocationContext contexts = this.icc.suspend();
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            this.setTx(ctx, e);
            e.setType(Event.Type.CACHE_ENTRY_INVALIDATED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryInvalidatedListeners) {
                listener.invoke(e);
            }
            this.icc.resume(contexts);
        }
    }

    @Override
    public void notifyCacheEntryLoaded(Object key, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryLoadedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            InvocationContext contexts = this.icc.suspend();
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            this.setTx(ctx, e);
            e.setType(Event.Type.CACHE_ENTRY_LOADED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryLoadedListeners) {
                listener.invoke(e);
            }
            this.icc.resume(contexts);
        }
    }

    @Override
    public void notifyCacheEntryActivated(Object key, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryActivatedListeners.isEmpty()) {
            boolean originLocal = ctx.isOriginLocal();
            InvocationContext contexts = this.icc.suspend();
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(originLocal);
            e.setPre(pre);
            e.setKey(key);
            this.setTx(ctx, e);
            e.setType(Event.Type.CACHE_ENTRY_ACTIVATED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryActivatedListeners) {
                listener.invoke(e);
            }
            this.icc.resume(contexts);
        }
    }

    private void setTx(InvocationContext ctx, EventImpl e) {
        if (ctx.isInTxScope()) {
            GlobalTransaction tx = ((TxInvocationContext)ctx).getGlobalTransaction();
            e.setTransactionId(tx);
        }
    }

    @Override
    public void notifyCacheEntryPassivated(Object key, boolean pre, InvocationContext ctx) {
        if (!this.cacheEntryPassivatedListeners.isEmpty()) {
            InvocationContext contexts = this.icc.suspend();
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setPre(pre);
            e.setKey(key);
            this.setTx(ctx, e);
            e.setType(Event.Type.CACHE_ENTRY_PASSIVATED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.cacheEntryPassivatedListeners) {
                listener.invoke(e);
            }
            this.icc.resume(contexts);
        }
    }

    @Override
    public void notifyTransactionCompleted(GlobalTransaction transaction, boolean successful, InvocationContext ctx) {
        if (!this.transactionCompletedListeners.isEmpty()) {
            boolean isOriginLocal = ctx.isOriginLocal();
            InvocationContext contexts = this.icc.suspend();
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(isOriginLocal);
            e.setTransactionId(transaction);
            e.setTransactionSuccessful(successful);
            e.setType(Event.Type.TRANSACTION_COMPLETED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.transactionCompletedListeners) {
                listener.invoke(e);
            }
            this.icc.resume(contexts);
        }
    }

    @Override
    public void notifyTransactionRegistered(GlobalTransaction globalTransaction, InvocationContext ctx) {
        if (!this.transactionRegisteredListeners.isEmpty()) {
            boolean isOriginLocal = ctx.isOriginLocal();
            InvocationContext contexts = this.icc.suspend();
            EventImpl e = new EventImpl();
            e.setCache(this.cache);
            e.setOriginLocal(isOriginLocal);
            e.setTransactionId(globalTransaction);
            e.setType(Event.Type.TRANSACTION_REGISTERED);
            for (AbstractListenerImpl.ListenerInvocation listener : this.transactionRegisteredListeners) {
                listener.invoke(e);
            }
            this.icc.resume(contexts);
        }
    }

    static {
        allowedListeners.put(CacheEntryCreated.class, CacheEntryCreatedEvent.class);
        allowedListeners.put(CacheEntryRemoved.class, CacheEntryRemovedEvent.class);
        allowedListeners.put(CacheEntryVisited.class, CacheEntryVisitedEvent.class);
        allowedListeners.put(CacheEntryModified.class, CacheEntryModifiedEvent.class);
        allowedListeners.put(CacheEntryActivated.class, CacheEntryActivatedEvent.class);
        allowedListeners.put(CacheEntryPassivated.class, CacheEntryPassivatedEvent.class);
        allowedListeners.put(CacheEntryLoaded.class, CacheEntryLoadedEvent.class);
        allowedListeners.put(CacheEntryEvicted.class, CacheEntryEvictedEvent.class);
        allowedListeners.put(TransactionRegistered.class, TransactionRegisteredEvent.class);
        allowedListeners.put(TransactionCompleted.class, TransactionCompletedEvent.class);
        allowedListeners.put(CacheEntryInvalidated.class, CacheEntryInvalidatedEvent.class);
    }
}

