/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.ConfigurationValidatingVisitor;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.InfinispanConfiguration;
import org.infinispan.config.parsing.XmlConfigurationParser;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.InternalCacheFactory;
import org.infinispan.factories.annotations.NonVolatile;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.Lifecycle;
import org.infinispan.manager.CacheManager;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.Immutables;

@Scope(value=Scopes.GLOBAL)
@NonVolatile
@MBean(objectName="CacheManager", description="Component that acts as a manager, factory and container for caches in the system.")
public class DefaultCacheManager
implements CacheManager {
    public static final String DEFAULT_CACHE_NAME = "org.infinispan.manager.DefaultCacheManager.DEFAULT_CACHE_NAME";
    protected GlobalConfiguration globalConfiguration;
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private final ConcurrentMap<String, Configuration> configurationOverrides = new ConcurrentHashMap<String, Configuration>();
    private GlobalComponentRegistry globalComponentRegistry;

    public DefaultCacheManager() {
        this(null, null, true);
    }

    public DefaultCacheManager(boolean start) {
        this(null, null, start);
    }

    public DefaultCacheManager(Configuration defaultConfiguration) {
        this(null, defaultConfiguration, true);
    }

    public DefaultCacheManager(Configuration defaultConfiguration, boolean start) {
        this(null, defaultConfiguration, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration) {
        this(globalConfiguration, null, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, boolean start) {
        this(globalConfiguration, null, start);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration) {
        this(globalConfiguration, defaultConfiguration, true);
    }

    public DefaultCacheManager(GlobalConfiguration globalConfiguration, Configuration defaultConfiguration, boolean start) {
        this.globalConfiguration = globalConfiguration == null ? new GlobalConfiguration() : globalConfiguration.clone();
        this.globalConfiguration.setDefaultConfiguration(defaultConfiguration == null ? new Configuration() : defaultConfiguration.clone());
        this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this);
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(String configurationFile) throws IOException {
        this(configurationFile, true);
    }

    public DefaultCacheManager(String configurationFile, boolean start) throws IOException {
        try {
            InfinispanConfiguration configuration = InfinispanConfiguration.newInfinispanConfiguration(configurationFile, InfinispanConfiguration.resolveSchemaPath(), (ConfigurationBeanVisitor)new ConfigurationValidatingVisitor());
            this.initialize(configuration);
        }
        catch (RuntimeException re) {
            throw new ConfigurationException(re);
        }
        if (start) {
            this.start();
        }
    }

    public DefaultCacheManager(InputStream configurationStream) throws IOException {
        this(configurationStream, true);
    }

    public DefaultCacheManager(InputStream configurationStream, boolean start) throws IOException {
        try {
            InfinispanConfiguration configuration = InfinispanConfiguration.newInfinispanConfiguration(configurationStream, InfinispanConfiguration.findSchemaInputStream(), (ConfigurationBeanVisitor)new ConfigurationValidatingVisitor());
            this.initialize(configuration);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw new ConfigurationException(re);
        }
        if (start) {
            this.start();
        }
    }

    private void initialize(XmlConfigurationParser initializedParser) {
        this.globalConfiguration = initializedParser.parseGlobalConfiguration();
        for (Map.Entry<String, Configuration> entry : initializedParser.parseNamedConfigurations().entrySet()) {
            Configuration c = this.globalConfiguration.getDefaultConfiguration().clone();
            c.applyOverrides(entry.getValue());
            this.configurationOverrides.put(entry.getKey(), c);
        }
        this.globalComponentRegistry = new GlobalComponentRegistry(this.globalConfiguration, this);
    }

    @Override
    public Configuration defineConfiguration(String cacheName, Configuration configurationOverride) {
        return this.defineConfiguration(cacheName, configurationOverride, this.globalConfiguration.getDefaultConfiguration(), true);
    }

    @Override
    public Configuration defineConfiguration(String cacheName, String templateName, Configuration configurationOverride) {
        if (templateName != null) {
            Configuration c = (Configuration)this.configurationOverrides.get(templateName);
            if (c != null) {
                return this.defineConfiguration(cacheName, configurationOverride, c, false);
            }
            return this.defineConfiguration(cacheName, configurationOverride);
        }
        return this.defineConfiguration(cacheName, configurationOverride);
    }

    private Configuration defineConfiguration(String cacheName, Configuration configOverride, Configuration defaultConfigIfNotPresent, boolean checkExisting) {
        Configuration existing;
        if (cacheName == null || configOverride == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        if (cacheName.equals(DEFAULT_CACHE_NAME)) {
            throw new IllegalArgumentException("Cache name cannot be used as it is a reserved, internal name");
        }
        if (checkExisting && (existing = (Configuration)this.configurationOverrides.get(cacheName)) != null) {
            existing.applyOverrides(configOverride);
            return existing.clone();
        }
        Configuration configuration = defaultConfigIfNotPresent.clone();
        configuration.applyOverrides(configOverride.clone());
        this.configurationOverrides.put(cacheName, configuration);
        return configuration;
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return this.getCache(DEFAULT_CACHE_NAME);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException("Null arguments not allowed");
        }
        if (this.caches.containsKey(cacheName)) {
            return (Cache)this.caches.get(cacheName);
        }
        return this.createCache(cacheName);
    }

    @Override
    public String getClusterName() {
        return this.globalConfiguration.getClusterName();
    }

    @Override
    public List<Address> getMembers() {
        if (this.globalComponentRegistry == null) {
            return null;
        }
        Transport t = this.globalComponentRegistry.getComponent(Transport.class);
        return t == null ? null : t.getMembers();
    }

    @Override
    public Address getAddress() {
        if (this.globalComponentRegistry == null) {
            return null;
        }
        Transport t = this.globalComponentRegistry.getComponent(Transport.class);
        return t == null ? null : t.getAddress();
    }

    @Override
    public boolean isCoordinator() {
        if (this.globalComponentRegistry == null) {
            return false;
        }
        Transport t = this.globalComponentRegistry.getComponent(Transport.class);
        return t != null && t.isCoordinator();
    }

    private Cache createCache(String cacheName) {
        Configuration c = null;
        c = cacheName.equals(DEFAULT_CACHE_NAME) || !this.configurationOverrides.containsKey(cacheName) ? this.globalConfiguration.getDefaultConfiguration().clone() : (Configuration)this.configurationOverrides.get(cacheName);
        c.assertValid();
        Cache cache = new InternalCacheFactory().createCache(c, this.globalComponentRegistry, cacheName);
        Cache other = this.caches.putIfAbsent(cacheName, cache);
        if (other == null) {
            cache.start();
            return cache;
        }
        return other;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        Lifecycle defaultCache = null;
        for (Map.Entry entry : this.caches.entrySet()) {
            if (((String)entry.getKey()).equals(DEFAULT_CACHE_NAME)) {
                defaultCache = (Cache)entry.getValue();
                continue;
            }
            ((Cache)entry.getValue()).stop();
        }
        if (defaultCache != null) {
            defaultCache.stop();
        }
        this.globalComponentRegistry.stop();
    }

    @Override
    public void addListener(Object listener) {
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        notifier.addListener(listener);
    }

    @Override
    public void removeListener(Object listener) {
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        notifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        CacheManagerNotifier notifier = this.globalComponentRegistry.getComponent(CacheManagerNotifier.class);
        return notifier.getListeners();
    }

    @Override
    public ComponentStatus getStatus() {
        return this.globalComponentRegistry.getStatus();
    }

    @Override
    public GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    @Override
    public Set<String> getCacheNames() {
        HashSet names = new HashSet(this.configurationOverrides.keySet());
        names.remove(DEFAULT_CACHE_NAME);
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        return Immutables.immutableSetWrap(names);
    }

    @ManagedAttribute(description="The defined cache names and their statuses.  The default cache is not included in this representation.")
    public String getDefinedCacheNames() {
        StringBuilder result = new StringBuilder("[");
        for (String cacheName : this.getCacheNames()) {
            boolean started = this.caches.containsKey(cacheName);
            result.append(cacheName).append(started ? "(created)" : "(not created)");
        }
        result.append("]");
        return result.toString();
    }

    @ManagedAttribute(description="The total number of defined caches, excluding the default cache.")
    public String getDefinedCacheCount() {
        return String.valueOf(this.configurationOverrides.keySet().size());
    }

    @ManagedAttribute(description="The total number of running caches, including the default cache.")
    public String getCreatedCacheCount() {
        return String.valueOf(this.caches.keySet().size());
    }

    @ManagedAttribute(description="Infinispan version")
    public String getVersion() {
        return Version.printVersion();
    }

    public String toString() {
        return super.toString() + "@Address:" + this.getAddress();
    }
}

