/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.CacheException;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ComponentsJmxRegistration {
    private static final Log log = LogFactory.getLog(ComponentsJmxRegistration.class);
    private MBeanServer mBeanServer;
    private String jmxDomain;
    private String groupName;
    private Set<AbstractComponentRegistry.Component> components;
    public static final String CACHE_NAME_KEY = "cache-name";
    public static final String JMX_RESOURCE_KEY = "jmx-resource";

    public ComponentsJmxRegistration(MBeanServer mBeanServer, Set<AbstractComponentRegistry.Component> components, String groupName) {
        this.mBeanServer = mBeanServer;
        this.components = components;
        this.groupName = groupName;
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    public void registerMBeans() throws CacheException {
        try {
            List<ResourceDMBean> resourceDMBeans = this.getResourceDMBeansFromComponents();
            for (ResourceDMBean resource : resourceDMBeans) {
                String resourceName = resource.getObjectName();
                ObjectName objectName = new ObjectName(this.getObjectName(resourceName));
                if (!this.mBeanServer.isRegistered(objectName)) {
                    try {
                        this.mBeanServer.registerMBean(resource, objectName);
                    }
                    catch (InstanceAlreadyExistsException e) {
                        log.info("Could not register object with name:" + objectName + "(" + e.getMessage() + ")");
                    }
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info("Could not register object with name: " + objectName);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while registering mbeans", e);
        }
    }

    public void unregisterMBeans() throws CacheException {
        log.trace("Unregistering jmx resources..");
        try {
            List<ResourceDMBean> resourceDMBeans = this.getResourceDMBeansFromComponents();
            for (ResourceDMBean resource : resourceDMBeans) {
                String resourceName = resource.getObjectName();
                ObjectName objectName = new ObjectName(this.getObjectName(resourceName));
                if (!this.mBeanServer.isRegistered(objectName)) continue;
                this.mBeanServer.unregisterMBean(objectName);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while unregistering mbeans", e);
        }
    }

    private List<ResourceDMBean> getResourceDMBeansFromComponents() {
        ArrayList<ResourceDMBean> resourceDMBeans = new ArrayList<ResourceDMBean>();
        for (AbstractComponentRegistry.Component component : this.components) {
            ResourceDMBean resourceDMBean = new ResourceDMBean(component.getInstance());
            if (!resourceDMBean.isManagedResource()) continue;
            resourceDMBeans.add(resourceDMBean);
        }
        return resourceDMBeans;
    }

    public String getObjectName(String resourceName) {
        return ComponentsJmxRegistration.getObjectName(this.jmxDomain, this.groupName, resourceName);
    }

    public static String getObjectName(String jmxDomain, String groupName, String resourceName) {
        return jmxDomain + ":" + CACHE_NAME_KEY + "=" + groupName + "," + JMX_RESOURCE_KEY + "=" + resourceName;
    }
}

