/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.transaction.TransactionLog;
import org.infinispan.transaction.xa.TransactionTable;
import org.infinispan.transaction.xa.TransactionXaAdapter;

@MBean(objectName="Transactions", description="Component that manages the cache's participation in JTA transactions.")
public class TxInterceptor
extends CommandInterceptor {
    private TransactionManager tm;
    private TransactionLog transactionLog;
    private TransactionTable txTable;
    private final AtomicLong prepares = new AtomicLong(0L);
    private final AtomicLong commits = new AtomicLong(0L);
    private final AtomicLong rollbacks = new AtomicLong(0L);
    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", writable=true)
    private boolean statisticsEnabled;

    @Inject
    public void init(TransactionManager tm, TransactionTable txTable, TransactionLog transactionLog, Configuration c) {
        this.configuration = c;
        this.tm = tm;
        this.transactionLog = transactionLog;
        this.txTable = txTable;
        this.setStatisticsEnabled(this.configuration.isExposeJmxStatistics());
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            for (WriteCommand modification : command.getModifications()) {
                VisitableCommand toReplay = this.getCommandToReplay(modification);
                if (toReplay == null) continue;
                this.invokeNextInterceptor(ctx, toReplay);
            }
        }
        if (!command.isOnePhaseCommit()) {
            this.transactionLog.logPrepare(command);
        }
        if (this.statisticsEnabled) {
            this.prepares.incrementAndGet();
        }
        Object result = this.invokeNextInterceptor(ctx, command);
        if (command.isOnePhaseCommit()) {
            this.transactionLog.logOnePhaseCommit(ctx.getGlobalTransaction(), command.getModifications());
        }
        return result;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.statisticsEnabled) {
            this.commits.incrementAndGet();
        }
        Object result = this.invokeNextInterceptor(ctx, command);
        this.transactionLog.logCommit(command.getGlobalTransaction());
        return result;
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.statisticsEnabled) {
            this.rollbacks.incrementAndGet();
        }
        this.transactionLog.rollback(command.getGlobalTransaction());
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    protected VisitableCommand getCommandToReplay(VisitableCommand modification) {
        return modification;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand invalidateCommand) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, invalidateCommand);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    private Object enlistReadAndInvokeNext(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (this.shouldEnlist(ctx)) {
            TransactionXaAdapter xaAdapter = this.enlist(ctx);
            LocalTxInvocationContext localTxContext = (LocalTxInvocationContext)ctx;
            localTxContext.setXaCache(xaAdapter);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Object enlistWriteAndInvokeNext(InvocationContext ctx, WriteCommand command) throws Throwable {
        TransactionXaAdapter xaAdapter = null;
        boolean shouldAddMod = false;
        if (this.shouldEnlist(ctx)) {
            xaAdapter = this.enlist(ctx);
            LocalTxInvocationContext localTxContext = (LocalTxInvocationContext)ctx;
            if (!this.isLocalModeForced(ctx)) {
                shouldAddMod = true;
            }
            localTxContext.setXaCache(xaAdapter);
        }
        Object rv = this.invokeNextInterceptor(ctx, command);
        if (!ctx.isInTxScope()) {
            this.transactionLog.logNoTxWrite(command);
        }
        if (command.isSuccessful() && shouldAddMod) {
            xaAdapter.addModification(command);
        }
        return rv;
    }

    public TransactionXaAdapter enlist(InvocationContext ctx) throws SystemException, RollbackException {
        Transaction transaction = this.tm.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("This should only be called in an tx scope");
        }
        int status = transaction.getStatus();
        if (!this.isValid(status)) {
            throw new IllegalStateException("Transaction " + transaction + " is not in a valid state to be invoking cache operations on.");
        }
        return this.txTable.getOrCreateXaAdapter(transaction, ctx);
    }

    private boolean isValid(int status) {
        return status == 0 || status == 7;
    }

    private boolean shouldEnlist(InvocationContext ctx) {
        return ctx.isInTxScope() && ctx.isOriginLocal();
    }

    private boolean isLocalModeForced(InvocationContext icx) {
        if (icx.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            if (this.trace) {
                this.log.debug("LOCAL mode forced on invocation.  Suppressing clustered events.");
            }
            return true;
        }
        return false;
    }

    @ManagedOperation(description="Resets statistics gathered by this component")
    public void resetStatistics() {
        this.prepares.set(0L);
        this.commits.set(0L);
        this.rollbacks.set(0L);
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute(description="number of transaction prepares")
    public long getPrepares() {
        return this.prepares.get();
    }

    @ManagedAttribute(description="number of transaction commits")
    public long getCommits() {
        return this.commits.get();
    }

    @ManagedAttribute(description="number of transaction rollbacks")
    public long getRollbacks() {
        return this.rollbacks.get();
    }
}

