/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;

public class InvocationContextInterceptor
extends CommandInterceptor {
    @Override
    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        return this.handleAll(ctx, command);
    }

    private Object handleAll(InvocationContext ctx, VisitableCommand command) throws Throwable {
        boolean suppressExceptions = false;
        if (this.trace) {
            this.log.trace("Invoked with command " + command + " and InvocationContext [" + ctx + "]");
        }
        if (ctx == null) {
            throw new IllegalStateException("Null context not allowed!!");
        }
        if (ctx.hasFlag(Flag.FAIL_SILENTLY)) {
            suppressExceptions = true;
        }
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        catch (Throwable th) {
            if (suppressExceptions) {
                this.log.trace((Object)"Exception while executiong code, failing silently...", th);
                Object var5_6 = null;
                return var5_6;
            }
            this.log.error((Object)"Execution error: ", th);
            throw th;
        }
        finally {
            ctx.reset();
        }
    }
}

