/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.List;
import java.util.Map;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.CacheStoreInterceptor;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;

public class DistCacheStoreInterceptor
extends CacheStoreInterceptor {
    DistributionManager dm;
    Address address;

    @Inject
    public void inject(DistributionManager dm, Transport transport) {
        this.dm = dm;
        this.address = transport.getAddress();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        Object key = command.getKey();
        if (this.skip(ctx, key) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        InternalCacheEntry se = this.getStoredEntry(key, ctx);
        this.store.store(se);
        this.log.trace((Object)"Stored entry {0} under key {1}", se, key);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (this.skip(ctx) || ctx.isInTxScope()) {
            return returnValue;
        }
        Map<Object, Object> map = command.getMap();
        for (Object key : map.keySet()) {
            if (this.skip(key)) continue;
            InternalCacheEntry se = this.getStoredEntry(key, ctx);
            this.store.store(se);
            this.log.trace((Object)"Stored entry {0} under key {1}", se, key);
        }
        if (this.getStatisticsEnabled()) {
            this.cacheStores.getAndAdd(map.size());
        }
        return returnValue;
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        Object key = command.getKey();
        if (!this.skip(ctx, key) && !ctx.isInTxScope() && command.isSuccessful()) {
            boolean resp = this.store.remove(key);
            this.log.trace((Object)"Removed entry under key {0} and got response {1} from CacheStore", key, resp);
        }
        return retval;
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        Object key = command.getKey();
        if (this.skip(ctx, key) || ctx.isInTxScope() || !command.isSuccessful()) {
            return returnValue;
        }
        InternalCacheEntry se = this.getStoredEntry(key, ctx);
        this.store.store(se);
        this.log.trace((Object)"Stored entry {0} under key {1}", se, key);
        if (this.getStatisticsEnabled()) {
            this.cacheStores.incrementAndGet();
        }
        return returnValue;
    }

    private boolean skip(InvocationContext ctx, Object key) {
        if (this.store == null) {
            return true;
        }
        List<Address> addresses = this.dm.locate(key);
        if (this.loaderConfig.isShared().booleanValue() && !this.isFirstOwner(addresses) || ctx.hasFlag(Flag.SKIP_CACHE_STORE) || this.isL1Put(addresses)) {
            if (this.trace) {
                this.log.trace("Passing up method call and bypassing this interceptor since the cache loader is either shared and the caller is not the first owner of the key, or the put call is an L1 put, or the call contain a skip cache store flag");
            }
            return true;
        }
        return false;
    }

    private final boolean skip(InvocationContext ctx) {
        if (this.store == null) {
            return true;
        }
        if (ctx.hasFlag(Flag.SKIP_CACHE_STORE)) {
            if (this.trace) {
                this.log.trace("Passing up method call and bypassing this interceptor since the call contain a skip cache store flag");
            }
            return true;
        }
        return false;
    }

    private boolean skip(Object key) {
        List<Address> addresses = this.dm.locate(key);
        if (this.loaderConfig.isShared().booleanValue() && !this.isFirstOwner(addresses) || this.isL1Put(addresses)) {
            if (this.trace) {
                this.log.trace("Passing up method call and bypassing this interceptor since the cache loader is either shared and the caller is not the first owner of the key, or the put call is an L1 put");
            }
            return true;
        }
        return false;
    }

    private boolean isL1Put(List<Address> addresses) {
        return !addresses.contains(this.address);
    }

    private boolean isFirstOwner(List<Address> addresses) {
        return addresses.get(0).equals(this.address);
    }
}

